/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.villager;

import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerTrades;

public class ActionAddWanderingTrade
extends ActionTradeBase {
    private final VillagerTrades.ItemListing trade;

    public ActionAddWanderingTrade(int level, VillagerTrades.ItemListing trade) {
        super(level);
        this.trade = trade;
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getTrades() {
        return VillagerTrades.WANDERING_TRADER_TRADES;
    }

    @Override
    public void apply() {
        List<VillagerTrades.ItemListing> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<VillagerTrades.ItemListing> tradeList) {
        tradeList.add(this.trade);
    }

    @Override
    public String describe() {
        return String.format("Adding Wandering Trader trade for Level: '%s'", this.level);
    }

    @Override
    public void undo() {
        List<VillagerTrades.ItemListing> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<VillagerTrades.ItemListing> tradeList) {
        tradeList.remove(this.trade);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing addition of Wandering Trader trade for Level: '%s'", this.level);
    }
}

