/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class LargeAercloudStructure
extends Structure {
    public static final MapCodec<LargeAercloudStructure> CODEC = RecordCodecBuilder.mapCodec(p_229075_ -> p_229075_.group((App)LargeAercloudStructure.settingsCodec((RecordCodecBuilder.Instance)p_229075_), (App)BlockStateProvider.CODEC.fieldOf("blocks").forGetter(structure -> structure.blocks), (App)Codec.INT.fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY)).apply((Applicative)p_229075_, LargeAercloudStructure::new));
    private final BlockStateProvider blocks;
    private final int size;
    private final int rangeY;

    public LargeAercloudStructure(Structure.StructureSettings settings, BlockStateProvider blocks, int size, int rangeY) {
        super(settings);
        this.blocks = blocks;
        this.size = size;
        this.rangeY = rangeY;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return Structure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> LargeAercloudStructure.generatePieces(builder, context, this.blocks, this.size, this.rangeY));
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockStateProvider blocks, int size, int rangeY) {
        LinkedHashMap<ChunkPos, Set> chunks = new LinkedHashMap<ChunkPos, Set>();
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        WorldgenRandom random = context.random();
        boolean direction = random.nextBoolean();
        int initialY = context.heightAccessor().getMinBuildHeight() + context.random().nextInt(rangeY);
        int x = context.chunkPos().getMinBlockX();
        int y = initialY;
        int z = context.chunkPos().getMinBlockZ();
        int xTendency = random.nextInt(3) - 1;
        int zTendency = random.nextInt(3) - 1;
        for (int amount = 0; amount < 64; ++amount) {
            y += random.nextInt(10) == 0 ? random.nextInt(3) - 1 : 0;
            z += direction ? random.nextInt(3) - 1 + zTendency : -(random.nextInt(3) - 1 + zTendency);
            for (int x1 = x += random.nextInt(3) - 1 + xTendency; x1 < x + random.nextInt(4) + 3 * size; ++x1) {
                for (int y1 = y; y1 < y + random.nextInt(1) + 2; ++y1) {
                    for (int z1 = z; z1 < z + random.nextInt(4) + 3 * size; ++z1) {
                        BlockPos newPosition = new BlockPos(x1, y1, z1);
                        if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 * size + random.nextInt(2)) continue;
                        positions.add(newPosition);
                        chunks.putIfAbsent(new ChunkPos(newPosition), new HashSet());
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            LinkedHashSet<BlockPos> withinChunk = new LinkedHashSet<BlockPos>(positions);
            withinChunk.removeIf(pos -> !new ChunkPos(pos).equals(chunkPos));
            blockPosSet.addAll(withinChunk);
        });
        int finalY = y;
        Direction orientation = Direction.Plane.HORIZONTAL.getRandomDirection((RandomSource)context.random());
        chunks.forEach((chunkPos, blockPosSet) -> {
            if (blockPosSet.isEmpty()) {
                return;
            }
            BoundingBox boundingBox = new BoundingBox(chunkPos.getMinBlockX(), Math.max(initialY - 16, 0), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), finalY + 16, chunkPos.getMaxBlockZ());
            builder.addPiece((StructurePiece)new LargeAercloudChunk((Set<BlockPos>)blockPosSet, blocks, boundingBox, orientation));
        });
    }

    public StructureType<?> type() {
        return (StructureType)AetherStructureTypes.LARGE_AERCLOUD.get();
    }
}

