/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClearItemPacket(int playerID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClearItemPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"clear_held_item"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClearItemPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClearItemPacket::playerID, ClearItemPacket::new);

    public CustomPacketPayload.Type<ClearItemPacket> type() {
        return TYPE;
    }

    public static void execute(ClearItemPacket payload, IPayloadContext context) {
        Entity entity;
        Player playerEntity = context.player();
        if (playerEntity.getServer() != null && (entity = playerEntity.level().getEntity(payload.playerID())) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
        }
    }
}

