/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ZephyrSnowballHitPacket(int entityID, double xSpeed, double zSpeed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ZephyrSnowballHitPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"zephyr_snowball_knockback_player"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ZephyrSnowballHitPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ZephyrSnowballHitPacket::entityID, (StreamCodec)ByteBufCodecs.DOUBLE, ZephyrSnowballHitPacket::xSpeed, (StreamCodec)ByteBufCodecs.DOUBLE, ZephyrSnowballHitPacket::zSpeed, ZephyrSnowballHitPacket::new);

    public CustomPacketPayload.Type<ZephyrSnowballHitPacket> type() {
        return TYPE;
    }

    public static void execute(ZephyrSnowballHitPacket payload, IPayloadContext context) {
        Entity entity;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().player.level().getEntity(payload.entityID())) instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            if (!localPlayer.isBlocking()) {
                localPlayer.setDeltaMovement(localPlayer.getDeltaMovement().x(), localPlayer.getDeltaMovement().y() + 0.5, localPlayer.getDeltaMovement().z());
            }
            localPlayer.setDeltaMovement(localPlayer.getDeltaMovement().x() + payload.xSpeed() * 1.5, localPlayer.getDeltaMovement().y(), localPlayer.getDeltaMovement().z() + payload.zSpeed() * 1.5);
        }
    }
}

