/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.entity.passive.Aerbunny;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemountAerbunnyPacket(int vehicleID, int aerbunnyID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemountAerbunnyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"remount_aerbunny"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemountAerbunnyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, RemountAerbunnyPacket::vehicleID, (StreamCodec)ByteBufCodecs.INT, RemountAerbunnyPacket::aerbunnyID, RemountAerbunnyPacket::new);

    public CustomPacketPayload.Type<RemountAerbunnyPacket> type() {
        return TYPE;
    }

    public static void execute(RemountAerbunnyPacket payload, IPayloadContext context) {
        Level world;
        Entity entity;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && (entity = (world = Minecraft.getInstance().player.level()).getEntity(payload.vehicleID())) instanceof Player) {
            Player player = (Player)entity;
            entity = world.getEntity(payload.aerbunnyID());
            if (entity instanceof Aerbunny) {
                Aerbunny aerbunny = (Aerbunny)entity;
                aerbunny.startRiding((Entity)player);
                ((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).setMountedAerbunny(aerbunny);
            }
        }
    }
}

