/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.item.miscellaneous.ConsumableItem;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LifeShardItem
extends Item
implements ConsumableItem {
    public LifeShardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (!player.isCreative()) {
            AetherPlayerAttachment aetherPlayer = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
            if (aetherPlayer.getLifeShardCount() < aetherPlayer.getLifeShardLimit()) {
                player.swing(hand);
                if (!level.isClientSide()) {
                    this.consume(this, heldStack, (LivingEntity)player);
                    aetherPlayer.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setLifeShardCount", aetherPlayer.getLifeShardCount() + 1);
                    return InteractionResultHolder.consume((Object)heldStack);
                }
                return InteractionResultHolder.success((Object)heldStack);
            }
            if (aetherPlayer.getLifeShardCount() >= aetherPlayer.getLifeShardLimit()) {
                player.displayClientMessage((Component)Component.translatable((String)"aether.life_shard_limit", (Object[])new Object[]{aetherPlayer.getLifeShardLimit()}), true);
            }
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }
}

