/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.ai.goal;

import com.aetherteam.aether.entity.NpcDialogue;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;

public class NpcDialogueGoal<T extends Mob>
extends LookAtPlayerGoal {
    private final T npc;

    public NpcDialogueGoal(T npc) {
        super(npc, Player.class, 8.0f);
        this.npc = npc;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (((NpcDialogue)this.npc).getConversingPlayer() != null && ((NpcDialogue)this.npc).getConversingPlayer().isAlive() && !((Mob)this.npc).hurtMarked && this.npc.distanceToSqr((Entity)((NpcDialogue)this.npc).getConversingPlayer()) <= 64.0) {
            this.lookAt = ((NpcDialogue)this.npc).getConversingPlayer();
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        super.start();
        this.npc.getNavigation().stop();
    }

    public void stop() {
        super.stop();
        ((NpcDialogue)this.npc).setConversingPlayer(null);
    }
}

