/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.command;

import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class AetherTimeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"aether").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"day").executes(context -> AetherTimeCommand.setTime((CommandSourceStack)context.getSource(), 1000 * AetherTimeAttachment.getTicksPerDayMultiplier())))).then(Commands.literal((String)"noon").executes(context -> AetherTimeCommand.setTime((CommandSourceStack)context.getSource(), 6000 * AetherTimeAttachment.getTicksPerDayMultiplier())))).then(Commands.literal((String)"night").executes(context -> AetherTimeCommand.setTime((CommandSourceStack)context.getSource(), 13000 * AetherTimeAttachment.getTicksPerDayMultiplier())))).then(Commands.literal((String)"midnight").executes(context -> AetherTimeCommand.setTime((CommandSourceStack)context.getSource(), 18000 * AetherTimeAttachment.getTicksPerDayMultiplier())))).then(Commands.argument((String)"time", (ArgumentType)TimeArgument.time()).executes(context -> AetherTimeCommand.setTime((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(Commands.literal((String)"add").then(Commands.argument((String)"time", (ArgumentType)TimeArgument.time()).executes(context -> AetherTimeCommand.addTime((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"query").then(Commands.literal((String)"daytime").executes(context -> AetherTimeCommand.queryTime((CommandSourceStack)context.getSource(), AetherTimeCommand.getDayTime(((CommandSourceStack)context.getSource()).getLevel()))))).then(Commands.literal((String)"day").executes(context -> AetherTimeCommand.queryTime((CommandSourceStack)context.getSource(), (int)(((CommandSourceStack)context.getSource()).getLevel().getDayTime() / (long)AetherTimeAttachment.getTicksPerDay() % Integer.MAX_VALUE)))))));
    }

    private static int getDayTime(ServerLevel level) {
        return (int)level.getDayTime();
    }

    private static int queryTime(CommandSourceStack source, int time) {
        source.sendSuccess(() -> Component.translatable((String)"commands.time.query", (Object[])new Object[]{time}), false);
        return time;
    }

    private static int setTime(CommandSourceStack source, int time) {
        ServerLevel level = source.getLevel();
        level.setDayTime((long)time);
        source.sendSuccess(() -> Component.translatable((String)"commands.time.set", (Object[])new Object[]{time}), true);
        return AetherTimeCommand.getDayTime(source.getLevel());
    }

    private static int addTime(CommandSourceStack source, int amount) {
        ServerLevel level = source.getLevel();
        level.setDayTime(level.getDayTime() + (long)amount);
        int i = AetherTimeCommand.getDayTime(source.getLevel());
        source.sendSuccess(() -> Component.translatable((String)"commands.time.set", (Object[])new Object[]{i}), true);
        return i;
    }
}

