/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.layers.SwetOuterLayer;
import com.aetherteam.aether.entity.monster.Swet;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class SwetRenderer
extends MobRenderer<Swet, SlimeModel<Swet>> {
    public SwetRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SlimeModel(context.bakeLayer(AetherModelLayers.SWET)), 0.3f);
        this.addLayer(new SwetOuterLayer((RenderLayerParent<Swet, SlimeModel<Swet>>)this, (SlimeModel<Swet>)new SlimeModel(context.bakeLayer(AetherModelLayers.SWET_OUTER))));
    }

    protected void scale(Swet swet, PoseStack poseStack, float partialTicks) {
        float scale = 1.5f;
        if (!swet.getPassengers().isEmpty()) {
            scale += (((Entity)swet.getPassengers().getFirst()).getBbWidth() + ((Entity)swet.getPassengers().getFirst()).getBbHeight()) * 0.75f;
        }
        float height = Mth.lerp((float)partialTicks, (float)swet.getSwetHeightO(), (float)swet.getSwetHeight());
        float width = Mth.lerp((float)partialTicks, (float)swet.getSwetWidthO(), (float)swet.getSwetWidth());
        poseStack.scale(width * scale, height * scale, width * scale);
        poseStack.scale(swet.getScale(), swet.getScale(), swet.getScale());
        this.shadowRadius = 0.3f * width;
    }
}

