/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.number;

import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorIntegerDivide
extends PieceOperator {
    SpellParam<Number> num1;
    SpellParam<Number> num2;
    SpellParam<Number> num3;

    public PieceOperatorIntegerDivide(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.num1 = new ParamNumber("psi.spellparam.number1", SpellParam.RED, false, false);
        this.addParam(this.num1);
        this.num2 = new ParamNumber("psi.spellparam.number2", SpellParam.GREEN, false, false);
        this.addParam(this.num2);
        this.num3 = new ParamNumber("psi.spellparam.number3", SpellParam.YELLOW, true, false);
        this.addParam(this.num3);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        double d4;
        double d1 = this.getParamValue(context, this.num1).doubleValue();
        Double d2 = this.getParamValue(context, this.num2).doubleValue();
        Number d3 = this.getParamValue(context, this.num3);
        if (d2 == 0.0 || ((Number)d2).intValue() == 0 || d3 != null && (d3.doubleValue() == 0.0 || d3.intValue() == 0)) {
            throw new SpellRuntimeException("psi.spellerror.dividebyzero", new Object[0]);
        }
        double d = d4 = d3 != null ? d1 / (d2 * d3.doubleValue()) : d1 / d2;
        if (d4 < 0.0) {
            return Math.ceil(d4);
        }
        return Math.floor(d4);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

