/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.crafting.recipe.TrickRecipe;

public class DimensionTrickRecipe
extends TrickRecipe {
    private final ResourceKey<Level> dimensionKey;

    public DimensionTrickRecipe(@Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad, ResourceKey<Level> dimensionKey) {
        super(piece, input, output, cad);
        this.dimensionKey = dimensionKey;
    }

    public DimensionTrickRecipe(@Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad, ResourceLocation dimensionKey) {
        this(piece, input, output, cad, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionKey));
    }

    @Override
    public boolean matches(SingleRecipeInput inv, Level world) {
        return super.matches(inv, world) && world.dimension() == this.dimensionKey;
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModCraftingRecipes.DIMENSION_TRICK_RECIPE_TYPE.get();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModCraftingRecipes.DIMENSION_TRICK_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<DimensionTrickRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, DimensionTrickRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<DimensionTrickRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)((TrickRecipe.Serializer)ModCraftingRecipes.TRICK_RECIPE_SERIALIZER.get()).codec().forGetter(d -> d), (App)ResourceLocation.CODEC.fieldOf("dimensionKey").forGetter(d -> d.dimensionKey.location())).apply((Applicative)instance, (recipe, dimensionId) -> new DimensionTrickRecipe(recipe.getPiece(), recipe.getInput(), recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), recipe.getAssembly(), (ResourceLocation)dimensionId)));

        private static DimensionTrickRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            TrickRecipe recipe = (TrickRecipe)((TrickRecipe.Serializer)ModCraftingRecipes.TRICK_RECIPE_SERIALIZER.get()).streamCodec().decode((Object)buf);
            ResourceLocation dimensionId = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
            return new DimensionTrickRecipe(recipe.getPiece(), recipe.getInput(), recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), recipe.getAssembly(), dimensionId);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, DimensionTrickRecipe recipe) {
            ((TrickRecipe.Serializer)ModCraftingRecipes.TRICK_RECIPE_SERIALIZER.get()).streamCodec().encode((Object)buf, (Object)recipe);
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)recipe.dimensionKey.location());
        }

        public MapCodec<DimensionTrickRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DimensionTrickRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

