/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.helper;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import vazkii.psi.common.Psi;

public final class SharingHelper {
    private static final String CLIENT_ID = "d5d2258f3526156";

    public static void uploadAndShare(String title, String export) {
        String url = SharingHelper.uploadImage(title, export);
        try {
            String contents = "## " + title + "  \n### [Image + Code](" + url + ")\n(to get the code click the link, RES won't show it)\n\n---\n*REPLACE THIS WITH A DESCRIPTION OF YOUR SPELL  \nMake sure you read the rules before posting. Look on the sidebar: https://www.reddit.com/r/psispellcompendium/  \nDelete this part before you submit.*";
            String encodedContents = URLEncoder.encode(contents, StandardCharsets.UTF_8);
            String encodedTitle = URLEncoder.encode(title, StandardCharsets.UTF_8);
            String redditUrl = "https://old.reddit.com/r/psispellcompendium/submit?title=" + encodedTitle + "&text=" + encodedContents;
            Util.getPlatform().openUri(new URI(redditUrl));
        }
        catch (Exception e) {
            Psi.logger.error("Error when trying to create a reddit post", (Throwable)e);
        }
    }

    public static void uploadAndOpen(String title, String export) {
        String url = SharingHelper.uploadImage(title, export);
        try {
            Util.getPlatform().openUri(new URI(url));
        }
        catch (Exception e) {
            Psi.logger.error("Error when trying to open uploaded image URL", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadImage(String title, String export) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String desc = "Spell Code:\n\n" + export;
            String url = "https://api.imgur.com/3/image";
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            list.add(new BasicNameValuePair("type", "base64"));
            list.add(new BasicNameValuePair("image", SharingHelper.takeScreenshot()));
            list.add(new BasicNameValuePair("name", title));
            list.add(new BasicNameValuePair("description", desc));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            post.addHeader("Authorization", "Client-ID d5d2258f3526156");
            CloseableHttpResponse res = client.execute((HttpUriRequest)post);
            JsonObject resJson = JsonParser.parseString((String)EntityUtils.toString((HttpEntity)res.getEntity())).getAsJsonObject();
            if (!resJson.has("success")) return "N/A";
            if (!resJson.get("success").getAsBoolean()) return "N/A";
            JsonObject data = resJson.get("data").getAsJsonObject();
            String id = data.get("id").getAsString();
            String string = "https://imgur.com/" + id;
            return string;
        }
        catch (Exception e) {
            Psi.logger.error("Error when uploading image to imgur", (Throwable)e);
        }
        return "N/A";
    }

    public static String takeScreenshot() throws Exception {
        Minecraft mc = Minecraft.getInstance();
        try (NativeImage image = Screenshot.takeScreenshot((RenderTarget)mc.getMainRenderTarget());){
            byte[] bArray = image.asByteArray();
            String string = Base64.getEncoder().encodeToString(bArray);
            return string;
        }
    }
}

