/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.client.gui.GuiSocketSelect;
import vazkii.psi.common.lib.LibResources;

@EventBusSubscriber(value={Dist.CLIENT}, modid="psi")
@OnlyIn(value=Dist.CLIENT)
public class KeybindHandler {
    public static KeyMapping keybind = new KeyMapping("psimisc.keybind", 67, "key.categories.psi");

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        event.register(keybind);
    }

    public static void keyDown() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null || mc.player == null) {
            return;
        }
        ItemStack stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (KeybindHandler.isSocketable((Player)mc.player, stack)) {
            mc.setScreen((Screen)new GuiSocketSelect(stack));
            return;
        }
        stack = mc.player.getItemInHand(InteractionHand.OFF_HAND);
        if (KeybindHandler.isSocketable((Player)mc.player, stack)) {
            mc.setScreen((Screen)new GuiSocketSelect(stack));
            return;
        }
        PatchouliAPI.get().openBookGUI(LibResources.PATCHOULI_BOOK);
    }

    private static boolean isSocketableController(Player player, ItemStack stack) {
        ItemStack[] stacks;
        if (!(stack.getItem() instanceof ISocketableController)) {
            return false;
        }
        for (ItemStack controlled : stacks = ((ISocketableController)stack.getItem()).getControlledStacks(player, stack)) {
            if (controlled.isEmpty() || !ISocketable.isSocketable(controlled)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSocketable(@NotNull Player player, @NotNull ItemStack stack) {
        return !stack.isEmpty() && (ISocketable.isSocketable(stack) || KeybindHandler.isSocketableController(player, stack));
    }
}

