/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell.detonator;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.detonator.DetonationEvent;

public interface IDetonationHandler {
    public static IDetonationHandler detonator(Entity entity) {
        return (IDetonationHandler)entity.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY);
    }

    public static void performDetonation(Level world, Player player) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, e -> true);
    }

    public static void performDetonation(Level world, Player player, double range) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, e -> true);
    }

    public static void performDetonation(Level world, Player player, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, filter);
    }

    public static void performDetonation(Level world, Player player, double range, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, filter);
    }

    public static void performDetonation(Level world, Player player, Entity center) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, e -> true);
    }

    public static void performDetonation(Level world, Player player, Entity center, double range) {
        IDetonationHandler.performDetonation(world, player, center, range, e -> true);
    }

    public static void performDetonation(Level world, Player player, Entity center, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, filter);
    }

    public static void performDetonation(Level world, Player player, Entity center, double range, Predicate<Entity> filter) {
        List charges = world.getEntitiesOfClass(Entity.class, center.getBoundingBox().inflate(range), entity -> {
            if (entity == null) {
                return false;
            }
            IDetonationHandler detonator = (IDetonationHandler)entity.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY);
            if (detonator != null) {
                Vec3 locus = detonator.objectLocus();
                if (locus == null || locus.distanceToSqr(center.getX(), center.getY(), center.getZ()) > range * range) {
                    return false;
                }
                return filter == null || filter.test((Entity)entity);
            }
            return false;
        });
        List<IDetonationHandler> handlers = charges.stream().map(e -> Objects.requireNonNull((IDetonationHandler)e.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY))).collect(Collectors.toList());
        if (!((DetonationEvent)NeoForge.EVENT_BUS.post((Event)new DetonationEvent(player, center, range, handlers))).isCanceled() && !handlers.isEmpty()) {
            for (IDetonationHandler handler : handlers) {
                handler.detonate();
            }
        }
    }

    default public Vec3 objectLocus() {
        return null;
    }

    public void detonate();
}

