/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import vazkii.psi.api.spell.IGenericRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;

public final class SpellGrid {
    public static final int GRID_SIZE = 9;
    public static final int GRID_CENTER = 4;
    private static final String TAG_SPELL_LIST = "spellList";
    private static final String TAG_SPELL_POS_X_LEGACY = "spellPosX";
    private static final String TAG_SPELL_POS_Y_LEGACY = "spellPosY";
    private static final String TAG_SPELL_DATA_LEGACY = "spellData";
    private static final String TAG_SPELL_POS_X = "x";
    private static final String TAG_SPELL_POS_Y = "y";
    private static final String TAG_SPELL_DATA = "data";
    public final Spell spell;
    public SpellPiece[][] gridData;
    private boolean empty;
    private int leftmost;
    private int rightmost;
    private int topmost;
    private int bottommost;
    public static final MapCodec<SpellGrid> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.lazyInitialized(() -> Codec.list((Codec)PieceWithPosition.CODEC.codec())).fieldOf(TAG_SPELL_LIST).forGetter(SpellGrid::getPiecesAsFlattenedList)).apply((Applicative)instance, SpellGrid::fromCodecData));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellGrid> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.lazy(() -> PieceWithPosition.STREAM_CODEC.apply(ByteBufCodecs.list())), SpellGrid::getPiecesAsFlattenedList, SpellGrid::fromCodecData);

    public SpellGrid(Spell spell) {
        this.spell = spell;
        this.gridData = new SpellPiece[9][9];
    }

    public static boolean exists(int x, int y) {
        return x >= 0 && y >= 0 && x < 9 && y < 9;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack pPoseStack, MultiBufferSource buffers, int light) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                pPoseStack.pushPose();
                pPoseStack.translate((float)(i * 18), (float)(j * 18), 0.0f);
                p.draw(pPoseStack, buffers, light);
                pPoseStack.popPose();
            }
        }
    }

    private void recalculateBoundaries() {
        this.empty = true;
        this.leftmost = 9;
        this.rightmost = -1;
        this.topmost = 9;
        this.bottommost = -1;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                this.empty = false;
                if (i < this.leftmost) {
                    this.leftmost = i;
                }
                if (i > this.rightmost) {
                    this.rightmost = i;
                }
                if (j < this.topmost) {
                    this.topmost = j;
                }
                if (j <= this.bottommost) continue;
                this.bottommost = j;
            }
        }
    }

    public int getSize() {
        this.recalculateBoundaries();
        if (this.empty) {
            return 0;
        }
        return Math.max(this.rightmost - this.leftmost + 1, this.bottommost - this.topmost + 1);
    }

    public void mirrorVertical() {
        this.recalculateBoundaries();
        if (this.empty) {
            return;
        }
        SpellPiece[][] newGrid = new SpellPiece[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                int newY = 9 - j - 1;
                newGrid[i][newY] = p;
                p.y = newY;
                p.paramSides.replaceAll((k, v) -> p.paramSides.get(k).mirrorVertical());
            }
        }
        this.gridData = newGrid;
    }

    public void rotate(boolean ccw) {
        this.recalculateBoundaries();
        if (this.empty) {
            return;
        }
        int xMod = ccw ? -1 : 1;
        int yMod = ccw ? 1 : -1;
        SpellPiece[][] newGrid = new SpellPiece[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                int newX = xMod * (j - 4) + 4;
                int newY = yMod * (i - 4) + 4;
                newGrid[newX][newY] = p;
                p.x = newX;
                p.y = newY;
                for (SpellParam<?> param : p.paramSides.keySet()) {
                    p.paramSides.compute(param, (k, side) -> ccw ? side.rotateCCW() : side.rotateCW());
                }
            }
        }
        this.gridData = newGrid;
    }

    public boolean shift(SpellParam.Side side, boolean doit) {
        this.recalculateBoundaries();
        if (this.empty) {
            return false;
        }
        if (SpellGrid.exists(this.leftmost + side.offx, this.topmost + side.offy) && SpellGrid.exists(this.rightmost + side.offx, this.bottommost + side.offy)) {
            if (!doit) {
                return true;
            }
            SpellPiece[][] newGrid = new SpellPiece[9][9];
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    SpellPiece p = this.gridData[i][j];
                    if (p == null) continue;
                    int newX = i + side.offx;
                    int newY = j + side.offy;
                    newGrid[newX][newY] = p;
                    p.x = newX;
                    p.y = newY;
                }
            }
            this.gridData = newGrid;
            return true;
        }
        return false;
    }

    private SpellPiece getPieceAtSide(Multimap<SpellPiece, SpellParam.Side> traversed, int x, int y, SpellParam.Side side) throws SpellCompilationException {
        SpellPiece atSide = this.getPieceAtSideSafely(x, y, side);
        if (!traversed.put((Object)atSide, (Object)side)) {
            throw new SpellCompilationException("psi.spellerror.loop");
        }
        return atSide;
    }

    @Deprecated
    public SpellPiece getPieceAtSideWithRedirections(List<SpellPiece> unused, int x, int y, SpellParam.Side side) throws SpellCompilationException {
        return this.getPieceAtSideWithRedirections(x, y, side);
    }

    public SpellPiece getPieceAtSideWithRedirections(int x, int y, SpellParam.Side side) throws SpellCompilationException {
        return this.getPieceAtSideWithRedirections(x, y, side, (SpellPiece piece) -> {});
    }

    public SpellPiece getPieceAtSideWithRedirections(int x, int y, SpellParam.Side side, SpellPieceConsumer walker) throws SpellCompilationException {
        SpellPiece atSide;
        HashMultimap traversed = HashMultimap.create();
        while ((atSide = this.getPieceAtSide((Multimap<SpellPiece, SpellParam.Side>)traversed, x, y, side)) instanceof IGenericRedirector) {
            IGenericRedirector redirector = (IGenericRedirector)((Object)atSide);
            walker.accept(atSide);
            SpellParam.Side rside = redirector.remapSide(side);
            if (!rside.isEnabled()) {
                return null;
            }
            side = rside;
            x = atSide.x;
            y = atSide.y;
        }
        return atSide;
    }

    public SpellPiece getPieceAtSideSafely(int x, int y, SpellParam.Side side) {
        int xp = x + side.offx;
        int yp = y + side.offy;
        if (!SpellGrid.exists(xp, yp)) {
            return null;
        }
        return this.gridData[xp][yp];
    }

    public boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                return false;
            }
        }
        return true;
    }

    public void readFromNBT(CompoundTag cmp) {
        this.gridData = new SpellPiece[9][9];
        ListTag list = cmp.getList(TAG_SPELL_LIST, 10);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            int posY;
            int posX;
            CompoundTag lcmp = list.getCompound(i);
            if (lcmp.contains(TAG_SPELL_POS_X_LEGACY)) {
                posX = lcmp.getInt(TAG_SPELL_POS_X_LEGACY);
                posY = lcmp.getInt(TAG_SPELL_POS_Y_LEGACY);
            } else {
                posX = lcmp.getInt(TAG_SPELL_POS_X);
                posY = lcmp.getInt(TAG_SPELL_POS_Y);
            }
            CompoundTag data = lcmp.contains(TAG_SPELL_DATA_LEGACY) ? lcmp.getCompound(TAG_SPELL_DATA_LEGACY) : lcmp.getCompound(TAG_SPELL_DATA);
            SpellPiece piece = SpellPiece.createFromNBT(this.spell, data);
            if (piece == null) continue;
            this.gridData[posX][posY] = piece;
            piece.isInGrid = true;
            piece.x = posX;
            piece.y = posY;
        }
    }

    private List<PieceWithPosition> getPiecesAsFlattenedList() {
        ArrayList<PieceWithPosition> pieces = new ArrayList<PieceWithPosition>();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                pieces.add(new PieceWithPosition(piece, i, j));
            }
        }
        return pieces;
    }

    private static SpellGrid fromCodecData(List<PieceWithPosition> spellList) {
        SpellGrid grid = new SpellGrid(new Spell());
        for (PieceWithPosition piece : spellList) {
            piece.piece.x = piece.x;
            piece.piece.y = piece.y;
            grid.gridData[piece.x][piece.y] = piece.piece;
        }
        grid.empty = spellList.isEmpty();
        return grid;
    }

    public void writeToNBT(CompoundTag cmp) {
        ListTag list = new ListTag();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                CompoundTag lcmp = new CompoundTag();
                lcmp.putInt(TAG_SPELL_POS_X, i);
                lcmp.putInt(TAG_SPELL_POS_Y, j);
                CompoundTag data = new CompoundTag();
                piece.writeToNBT(data);
                lcmp.put(TAG_SPELL_DATA, (Tag)data);
                list.add((Object)lcmp);
            }
        }
        cmp.put(TAG_SPELL_LIST, (Tag)list);
    }

    @FunctionalInterface
    public static interface SpellPieceConsumer {
        public void accept(SpellPiece var1) throws SpellCompilationException;
    }

    record PieceWithPosition(SpellPiece piece, int x, int y) {
        public static final MapCodec<PieceWithPosition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.lazyInitialized(() -> SpellPiece.CODEC).fieldOf(SpellGrid.TAG_SPELL_DATA).forGetter(PieceWithPosition::piece), (App)Codec.INT.fieldOf(SpellGrid.TAG_SPELL_POS_X).forGetter(PieceWithPosition::x), (App)Codec.INT.fieldOf(SpellGrid.TAG_SPELL_POS_Y).forGetter(PieceWithPosition::y)).apply((Applicative)instance, PieceWithPosition::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PieceWithPosition> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.lazy(() -> SpellPiece.STREAM_CODEC), PieceWithPosition::piece, (StreamCodec)ByteBufCodecs.VAR_INT, PieceWithPosition::x, (StreamCodec)ByteBufCodecs.VAR_INT, PieceWithPosition::y, PieceWithPosition::new);
    }
}

