/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.common.SimpleTier;
import org.apache.logging.log4j.LogManager;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.DummyMethodHandler;
import vazkii.psi.api.internal.IInternalMethodHandler;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.detonator.IDetonationHandler;
import vazkii.psi.common.item.base.ModItems;

public final class PsiAPI {
    public static final String MOD_ID = "psi";
    public static final EntityCapability<ISpellImmune, Void> SPELL_IMMUNE_CAPABILITY = EntityCapability.createVoid((ResourceLocation)PsiAPI.location("spell_immune"), ISpellImmune.class);
    public static final EntityCapability<IDetonationHandler, Void> DETONATION_HANDLER_CAPABILITY = EntityCapability.createVoid((ResourceLocation)PsiAPI.location("detonation_handler"), IDetonationHandler.class);
    public static final ItemCapability<IPsiBarDisplay, Void> PSI_BAR_DISPLAY_CAPABILITY = ItemCapability.createVoid((ResourceLocation)PsiAPI.location("psi_bar_display"), IPsiBarDisplay.class);
    public static final ItemCapability<ISpellAcceptor, Void> SPELL_ACCEPTOR_CAPABILITY = ItemCapability.createVoid((ResourceLocation)PsiAPI.location("spell_acceptor"), ISpellAcceptor.class);
    public static final ItemCapability<ICADData, Void> CAD_DATA_CAPABILITY = ItemCapability.createVoid((ResourceLocation)PsiAPI.location("cad_data"), ICADData.class);
    public static final ItemCapability<ISocketable, Void> SOCKETABLE_CAPABILITY = ItemCapability.createVoid((ResourceLocation)PsiAPI.location("socketable"), ISocketable.class);
    public static final ResourceKey<Registry<Class<? extends SpellPiece>>> SPELL_PIECE_REGISTRY_TYPE_KEY = ResourceKey.createRegistryKey((ResourceLocation)PsiAPI.location("spell_piece_registry_type_key"));
    private static final MappedRegistry<Class<? extends SpellPiece>> spellPieceRegistry = new MappedRegistry(SPELL_PIECE_REGISTRY_TYPE_KEY, Lifecycle.stable());
    public static final Tier PSIMETAL_TOOL_MATERIAL = new SimpleTier(BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 900, 7.8f, 2.0f, 12, () -> Ingredient.of((ItemLike[])new ItemLike[]{ModItems.psimetal}));
    private static final Multimap<ResourceLocation, Class<? extends SpellPiece>> advancementGroups = HashMultimap.create();
    private static final Map<Class<? extends SpellPiece>, ResourceLocation> advancementGroupsInverse = new HashMap<Class<? extends SpellPiece>, ResourceLocation>();
    private static final Map<ResourceLocation, Class<? extends SpellPiece>> mainPieceForGroup = new HashMap<ResourceLocation, Class<? extends SpellPiece>>();
    public static IInternalMethodHandler internalHandler = new DummyMethodHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSpellPiece(ResourceLocation resourceLocation, Class<? extends SpellPiece> clazz) {
        MappedRegistry<Class<? extends SpellPiece>> mappedRegistry = spellPieceRegistry;
        synchronized (mappedRegistry) {
            spellPieceRegistry.register(ResourceKey.create(SPELL_PIECE_REGISTRY_TYPE_KEY, (ResourceLocation)resourceLocation), clazz, RegistrationInfo.BUILT_IN);
        }
    }

    public static void registerSpellPieceAndTexture(ResourceLocation id, Class<? extends SpellPiece> clazz) {
        PsiAPI.registerSpellPiece(id, clazz);
        if (FMLEnvironment.dist.isClient()) {
            ClientPsiAPI.registerPieceTexture(id, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("spell/" + id.getPath())));
        }
    }

    public static void addPieceToGroup(Class<? extends SpellPiece> clazz, ResourceLocation resLoc, boolean main) {
        advancementGroups.put((Object)resLoc, clazz);
        advancementGroupsInverse.put(clazz, resLoc);
        if (main) {
            if (mainPieceForGroup.containsKey(resLoc)) {
                LogManager.getLogger((String)MOD_ID).info("Group {} already has a main piece!", (Object)resLoc);
            }
            mainPieceForGroup.put(resLoc, clazz);
        }
    }

    public static ItemStack getPlayerCAD(Player player) {
        if (player == null) {
            return ItemStack.EMPTY;
        }
        ItemStack cad = ItemStack.EMPTY;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stackAt = player.getInventory().getItem(i);
            if (stackAt.isEmpty() || !(stackAt.getItem() instanceof ICAD)) continue;
            if (!cad.isEmpty()) {
                return ItemStack.EMPTY;
            }
            cad = stackAt;
        }
        return cad;
    }

    public static int getPlayerCADSlot(Player player) {
        if (player == null) {
            return -1;
        }
        int slot = -1;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stackAt = player.getInventory().getItem(i);
            if (stackAt.isEmpty() || !(stackAt.getItem() instanceof ICAD)) continue;
            if (slot != -1) {
                return -1;
            }
            slot = i;
        }
        return slot;
    }

    public static boolean canCADBeUpdated(Player player) {
        if (player == null) {
            return false;
        }
        if (player.containerMenu == null) {
            return true;
        }
        int cadSlot = PsiAPI.getPlayerCADSlot(player);
        return cadSlot < 9 || cadSlot == 40;
    }

    public static Class<? extends SpellPiece> getSpellPiece(ResourceLocation key) {
        return (Class)spellPieceRegistry.get(key);
    }

    public static ResourceLocation getSpellPieceKey(Class<? extends SpellPiece> clazz) {
        return spellPieceRegistry.getKey(clazz);
    }

    public static Collection<Class<? extends SpellPiece>> getPiecesInAdvancementGroup(ResourceLocation group) {
        return advancementGroups.get((Object)group);
    }

    public static ResourceLocation getGroupForPiece(Class<? extends SpellPiece> piece) {
        return advancementGroupsInverse.get(piece);
    }

    public static Class<? extends SpellPiece> getMainPieceForGroup(ResourceLocation group) {
        return mainPieceForGroup.get(group);
    }

    public static boolean isPieceRegistered(ResourceLocation key) {
        return spellPieceRegistry.keySet().contains(key);
    }

    public static Collection<Class<? extends SpellPiece>> getAllRegisteredSpellPieces() {
        return spellPieceRegistry.stream().collect(Collectors.toList());
    }

    public static Collection<ResourceLocation> getAllPieceKeys() {
        return spellPieceRegistry.keySet();
    }

    public static MappedRegistry<Class<? extends SpellPiece>> getSpellPieceRegistry() {
        return spellPieceRegistry;
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

