/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;

public class DebugRenderersCommand {
    private static final ResourceKeyArgument<Structure> STRUCTURE_ARG = ResourceKeyArgument.key((ResourceKey)Registries.STRUCTURE);
    public static boolean DEBUG_NEIGHBOR_UPDATES = false;
    public static final DebugConfig<EntityType<?>> DEBUG_PATHFINDING = new DebugConfig(Registries.ENTITY_TYPE);
    public static final DebugConfig<EntityType<?>> DEBUG_GOAL_SELECTOR = new DebugConfig(Registries.ENTITY_TYPE);
    public static final DebugConfig<Structure> DEBUG_STRUCTURES_BB = new DebugConfig(Registries.STRUCTURE);

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug_renderers").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"neighbors_update").executes(DebugRenderersCommand::neighbors))).then(((LiteralArgumentBuilder)Commands.literal((String)"navigation").executes(DebugRenderersCommand::navigation)).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.ENTITY_TYPE)).executes(DebugRenderersCommand::navigation)).then(Commands.argument((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(DebugRenderersCommand::navigation))))).then(((LiteralArgumentBuilder)Commands.literal((String)"goals_selector").executes(DebugRenderersCommand::goals)).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.ENTITY_TYPE)).executes(DebugRenderersCommand::goals)).then(Commands.argument((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(DebugRenderersCommand::goals))))).then(((LiteralArgumentBuilder)Commands.literal((String)"structures").executes(DebugRenderersCommand::structures)).then(((RequiredArgumentBuilder)Commands.argument((String)"structure", STRUCTURE_ARG).executes(DebugRenderersCommand::structures)).then(Commands.argument((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(DebugRenderersCommand::structures))));
    }

    private static int navigation(CommandContext<CommandSourceStack> context) {
        DebugRenderersCommand.toggle(context, "entity", DEBUG_PATHFINDING, "navigation");
        return 0;
    }

    private static int neighbors(CommandContext<CommandSourceStack> context) {
        DEBUG_NEIGHBOR_UPDATES = BoolArgumentType.getBool(context, (String)"active");
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.moonlight.neighbor_updates", (Object[])new Object[]{DEBUG_NEIGHBOR_UPDATES}), false);
        return 0;
    }

    private static int goals(CommandContext<CommandSourceStack> context) {
        DebugRenderersCommand.toggle(context, "entity", DEBUG_GOAL_SELECTOR, "goal_selector");
        return 0;
    }

    private static int structures(CommandContext<CommandSourceStack> context) {
        DebugRenderersCommand.toggle(context, "structure", DEBUG_STRUCTURES_BB, "structures");
        return 0;
    }

    private static <T> void toggle(CommandContext<CommandSourceStack> ctx, String keyKey, DebugConfig<T> config, String translation) {
        MutableComponent comp;
        Boolean active = DebugRenderersCommand.getOptArg(ctx, "active", Boolean.class);
        Optional key = DebugRenderersCommand.getResourceKey(ctx, keyKey, config.registryKey);
        if (key.isPresent()) {
            ResourceLocation location = key.get().location();
            active = active != null ? active : !config.keys.contains(location);
            comp = active != false ? Component.translatable((String)("commands.moonlight." + translation + ".add"), (Object[])new Object[]{location.toString()}) : Component.translatable((String)("commands.moonlight." + translation + ".remove"), (Object[])new Object[]{location.toString()});
            config.toggleKey(location, active);
        } else {
            active = !config.allActive;
            comp = active != false ? Component.translatable((String)("commands.moonlight." + translation + ".on")) : Component.translatable((String)("commands.moonlight." + translation + ".off"));
            config.setActive(active);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> DebugRenderersCommand.lambda$toggle$2((Component)comp), false);
    }

    @Nullable
    private static Boolean getOptArg(CommandContext<CommandSourceStack> ctx, String active, Class<Boolean> booleanClass) {
        try {
            return (Boolean)ctx.getArgument(active, booleanClass);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> Optional<ResourceKey<T>> getResourceKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> registryKey) {
        try {
            ResourceKey key = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
            return key.cast(registryKey);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static /* synthetic */ Component lambda$toggle$2(Component comp) {
        return comp;
    }

    public static class DebugConfig<T> {
        private final ResourceKey<Registry<T>> registryKey;
        private final Set<ResourceLocation> keys = new HashSet<ResourceLocation>();
        private boolean allActive = false;

        public DebugConfig(ResourceKey<Registry<T>> registryKey) {
            this.registryKey = registryKey;
        }

        public boolean isActive(ResourceLocation key) {
            if (this.allActive) {
                return true;
            }
            if (this.keys.isEmpty()) {
                return false;
            }
            return this.keys.contains(key);
        }

        public boolean isActive(T element, Level level) {
            return this.isActive(element, level.registryAccess());
        }

        public boolean isActive(T element, RegistryAccess access) {
            if (this.allActive) {
                return true;
            }
            if (this.keys.isEmpty()) {
                return false;
            }
            return this.isActive(access.registryOrThrow(this.registryKey).getKey(element));
        }

        public boolean isActive(Holder<T> holder) {
            return this.isActive(((ResourceKey)holder.unwrapKey().get()).location());
        }

        private void setActive(boolean active) {
            this.allActive = active;
        }

        private void toggleKey(ResourceLocation key, boolean active) {
            if (active) {
                this.keys.add(key);
            } else {
                this.keys.remove(key);
            }
        }
    }
}

