/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;

public record SpawnBoxSettings(Map<MobCategory, Map<String, WeightedRandomList<MobSpawnSettings.SpawnerData>>> spawnOverrides) {
    public static final Codec<SpawnBoxSettings> CODEC = Entry.CODEC.listOf().flatXmap(SpawnBoxSettings::fromEntries, spawnBoxSettings -> DataResult.success(spawnBoxSettings.toEntryList()));
    public static final SpawnBoxSettings EMPTY = new SpawnBoxSettings(Map.of());

    private static DataResult<SpawnBoxSettings> fromEntries(List<Entry> entries) {
        HashMap<MobCategory, Map<String, WeightedRandomList<MobSpawnSettings.SpawnerData>>> map = new HashMap<MobCategory, Map<String, WeightedRandomList<MobSpawnSettings.SpawnerData>>>();
        for (Entry e : entries) {
            map.computeIfAbsent(e.category, k -> new HashMap());
            Map catMap = (Map)map.get(e.category);
            if (catMap.containsKey(e.name)) {
                return DataResult.error(() -> "Duplicate spawn box entry for category " + String.valueOf(e.category) + " and name " + e.name);
            }
            catMap.put(e.name, e.spawns);
        }
        return DataResult.success((Object)new SpawnBoxSettings(map));
    }

    private List<Entry> toEntryList() {
        return this.spawnOverrides.entrySet().stream().flatMap(catEntry -> ((Map)catEntry.getValue()).entrySet().stream().map(nameEntry -> new Entry((MobCategory)catEntry.getKey(), (String)nameEntry.getKey(), (WeightedRandomList<MobSpawnSettings.SpawnerData>)((WeightedRandomList)nameEntry.getValue())))).toList();
    }

    public boolean hasCategory(MobCategory category) {
        return this.spawnOverrides.containsKey(category);
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> get(String boxID, MobCategory category) {
        Map<String, WeightedRandomList<MobSpawnSettings.SpawnerData>> map = this.spawnOverrides.get(category);
        if (map != null) {
            return map.get(boxID);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.spawnOverrides.isEmpty();
    }

    private record Entry(MobCategory category, String name, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobCategory.CODEC.fieldOf("category").forGetter(Entry::category), (App)Codec.STRING.fieldOf("name").forGetter(Entry::name), (App)WeightedRandomList.codec((Codec)MobSpawnSettings.SpawnerData.CODEC).fieldOf("spawns").forGetter(Entry::spawns)).apply((Applicative)instance, Entry::new));
    }
}

