/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MthUtils {
    public static final float PHI = (float)(1.0 + (Math.sqrt(5.0) - 1.0) / 2.0);

    public static float[] polarToCartesian(float a, float r) {
        float x = r * Mth.cos((float)a);
        float y = r * Mth.sin((float)a);
        return new float[]{x, y};
    }

    public static float signedAngleDiff(double to, double from) {
        float x1 = Mth.cos((float)((float)to));
        float y1 = Mth.sin((float)((float)to));
        float x2 = Mth.cos((float)((float)from));
        float y2 = Mth.sin((float)((float)from));
        return (float)Mth.atan2((double)(x1 * y1 - y1 * x2), (double)(x1 * x2 + y1 * y2));
    }

    public static BlockPos relativePos(BlockPos pos, Direction normal, int left, int top, int forward) {
        Preconditions.checkArgument((normal.getAxis() != Direction.Axis.Y ? 1 : 0) != 0, (Object)"Normal direction cannot be vertical");
        if (forward != 0) {
            pos = pos.relative(normal, forward);
        }
        if (left != 0) {
            Direction leftDir = normal.getCounterClockWise();
            pos = pos.relative(leftDir, left);
        }
        if (top != 0) {
            pos = pos.above(top);
        }
        return pos;
    }

    public static float clampDegrees(float angle, float first, float second) {
        float diffB;
        float distanceToB;
        angle = (angle % 360.0f + 360.0f) % 360.0f;
        if ((first = (first % 360.0f + 360.0f) % 360.0f) == (second = (second % 360.0f + 360.0f) % 360.0f)) {
            return angle;
        }
        float deltaThetaA = (angle - first + 360.0f) % 360.0f;
        float deltaAB = (second - first + 360.0f) % 360.0f;
        if (deltaThetaA <= deltaAB) {
            return angle;
        }
        float diffA = Math.abs(angle - first);
        float distanceToA = Math.min(diffA, 360.0f - diffA);
        return Mth.wrapDegrees((float)(distanceToA < (distanceToB = Math.min(diffB = Math.abs(angle - second), 360.0f - diffB)) ? first : second));
    }

    public static Vec3 changeBasisN(Vec3 newBasisYVector, Vec3 rot) {
        Vec3 y = newBasisYVector.normalize();
        Vec3 x = new Vec3(y.y, y.z, y.x).normalize();
        Vec3 z = y.cross(x).normalize();
        return MthUtils.changeBasis(x, y, z, rot);
    }

    public static Vec3 changeBasis(Vec3 newX, Vec3 newY, Vec3 newZ, Vec3 rot) {
        return newX.scale(rot.x).add(newY.scale(rot.y)).add(newZ.scale(rot.z));
    }

    public static Vec3 getNormalFrom3DData(int direction) {
        return MthUtils.V3itoV3(Direction.from3DDataValue((int)direction).getNormal());
    }

    public static Vec3 V3itoV3(Vec3i v) {
        return new Vec3((double)v.getX(), (double)v.getY(), (double)v.getZ());
    }

    private static double isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3(dir.getNormal());
        Vec3 v2 = (Vec3)rot.apply(v);
        return v2.dot(new Vec3(0.0, 1.0, 0.0));
    }

    public static Vec3 rotateVec3(Vec3 vec, Direction dir) {
        double cos = 1.0;
        double sin = 0.0;
        switch (dir) {
            case SOUTH: {
                cos = -1.0;
                sin = 0.0;
                break;
            }
            case WEST: {
                cos = 0.0;
                sin = 1.0;
                break;
            }
            case EAST: {
                cos = 0.0;
                sin = -1.0;
                break;
            }
            case UP: {
                return new Vec3(vec.x, -vec.z, vec.y);
            }
            case DOWN: {
                return new Vec3(vec.x, vec.z, vec.y);
            }
        }
        double dx = vec.x * cos + vec.z * sin;
        double dy = vec.y;
        double dz = vec.z * cos - vec.x * sin;
        return new Vec3(dx, dy, dz);
    }

    public static float averageAngles(Float ... angles) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] floatArray = angles;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float a = floatArray[i].floatValue();
            x += Mth.cos((float)((float)((double)a * Math.PI * 2.0)));
            y += Mth.sin((float)((float)((double)a * Math.PI * 2.0)));
        }
        return (float)(Mth.atan2((double)y, (double)x) / (Math.PI * 2));
    }

    public static double getPitch(Vec3 vec3) {
        return -Math.toDegrees(Math.asin(vec3.y));
    }

    public static double getYaw(Vec3 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.x, vec3.z));
    }

    public static double getRoll(Vec3 vec3) {
        return Math.toDegrees(Math.atan2(vec3.y, vec3.x));
    }

    public static double wrapRad(double pValue) {
        double p = Math.PI * 2;
        double d0 = pValue % p;
        if (d0 >= Math.PI) {
            d0 -= p;
        }
        if (d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float wrapRad(float pValue) {
        float p = (float)Math.PI * 2;
        float d0 = pValue % p;
        if ((double)d0 >= Math.PI) {
            d0 -= p;
        }
        if ((double)d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float nextWeighted(RandomSource rand, float max, float bias) {
        float r = rand.nextFloat();
        if (bias <= 0.0f) {
            if (bias == 0.0f) {
                return r * max;
            }
            bias = -bias / (bias - 1.0f);
        }
        return max * (1.0f - r) / (bias * max * r + 1.0f);
    }

    public static float nextWeighted(RandomSource rand, float max, float bias, float min) {
        return MthUtils.nextWeighted(rand, max - min, bias) + min;
    }

    public static float nextWeighted(RandomSource rand, float max) {
        return MthUtils.nextWeighted(rand, max, 1.0f);
    }

    public static <T extends BaseColor<T>> T lerpColorScale(List<T> palette, float phase) {
        if (phase >= 1.0f) {
            phase %= 1.0f;
        }
        int n = palette.size();
        float g = (float)n * phase;
        int ind = (int)Math.floor(g);
        float delta = g % 1.0f;
        BaseColor start = (BaseColor)palette.get(ind);
        BaseColor end = (BaseColor)palette.get((ind + 1) % n);
        return (T)start.mixWith(end, delta);
    }

    public static boolean isWithinRectangle(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape source, Direction direction) {
        if (direction == Direction.NORTH) {
            return source;
        }
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.empty());
        source.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            Vec3 v1 = MthUtils.rotateVec3(min, direction);
            Vec3 v2 = MthUtils.rotateVec3(max, direction);
            VoxelShape s = Shapes.create((double)(0.5 + Math.min(v1.x, v2.x)), (double)(0.5 + Math.min(v1.y, v2.y)), (double)(0.5 + Math.min(v1.z, v2.z)), (double)(0.5 + Math.max(v1.x, v2.x)), (double)(0.5 + Math.max(v1.y, v2.y)), (double)(0.5 + Math.max(v1.z, v2.z)));
            newShape.set(Shapes.or((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static VoxelShape moveVoxelShape(VoxelShape source, Vec3 v) {
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.empty());
        source.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape s = Shapes.create((double)(minX + v.x), (double)(minY + v.y), (double)(minZ + v.z), (double)(maxX + v.x), (double)(maxY + v.y), (double)(maxZ + v.z));
            newShape.set(Shapes.or((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static double lambertW0(double x) {
        double maxError = 1.0E-6;
        if (x == -0.36787944117144233) {
            return -1.0;
        }
        if (x >= -0.36787944117144233) {
            double nLog = Math.log(x);
            double nLog0 = 1.0;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = x * Math.exp(-nLog) / (1.0 + nLog);
                nLog = x * Math.exp(-nLog0) / (1.0 + nLog0);
            }
            return Math.round(1000000.0 * nLog) / 1000000L;
        }
        throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be greater than or equal to -1/e.");
    }

    public static double lambertW1(double x) {
        double maxError = 1.0E-6;
        if (x == -0.36787944117144233) {
            return -1.0;
        }
        if (x < 0.0 && x > -0.36787944117144233) {
            double nLog = Math.log(-x);
            double nLog0 = 1.0;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = (nLog * nLog + x / Math.exp(nLog)) / (nLog + 1.0);
                nLog = (nLog0 * nLog0 + x / Math.exp(nLog0)) / (nLog0 + 1.0);
            }
            return Math.round(1000000.0 * nLog) / 1000000L;
        }
        if (x == 0.0) {
            return 0.0;
        }
        throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be in [-1/e,0]");
    }

    private static float exp01(float t, float base) {
        return (float)((double)base * Math.pow(1.0f / base + 1.0f, t) - (double)base);
    }

    public static float normalizedExponent(float t, float curve) {
        if (curve == 0.0f) {
            return t;
        }
        float base = curve > 0.0f ? (float)(-Math.log(curve)) : (float)(Math.log(-curve) - 1.0);
        return MthUtils.exp01(t, base);
    }

    public static BlockHitResult collideWithSweptAABB(Entity entity, Vec3 movement, double maxStep) {
        AABB aabb = entity.getBoundingBox();
        return MthUtils.collideWithSweptAABB(entity.position(), aabb, movement, entity.level(), maxStep);
    }

    public static BlockHitResult collideWithSweptAABB(Vec3 myPos, AABB myBox, Vec3 movement, Level level, double maxStep) {
        double len = movement.length();
        if (maxStep >= len) {
            return MthUtils.collideWithSweptAABB(myPos, myBox, movement, level);
        }
        Vec3 stepMovement = movement.normalize().scale(maxStep);
        Vec3 currentPos = myPos;
        for (double moved = 0.0; moved < len; moved += maxStep) {
            BlockHitResult result;
            if (moved + maxStep > len) {
                stepMovement = movement.scale((len - moved) / len);
            }
            if ((result = MthUtils.collideWithSweptAABB(currentPos, myBox, stepMovement, level)).getType() != HitResult.Type.MISS) {
                return result;
            }
            currentPos = currentPos.add(stepMovement);
            myBox = myBox.move(stepMovement);
        }
        Vec3 missPos = myPos.add(movement);
        return BlockHitResult.miss((Vec3)missPos, (Direction)Direction.UP, (BlockPos)BlockPos.containing((Position)missPos));
    }

    public static BlockHitResult collideWithSweptAABB(Vec3 myPos, AABB myBox, Vec3 movement, Level level) {
        AABB encompassing = myBox.expandTowards(movement);
        Set positions = BlockPos.betweenClosedStream((AABB)encompassing).map(BlockPos::immutable).collect(Collectors.toSet());
        CollisionResult earliestCollision = null;
        BlockPos hitPos = null;
        for (BlockPos pos : positions) {
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) continue;
            List boxes = state.getCollisionShape((BlockGetter)level, pos).toAabbs();
            for (AABB box : boxes) {
                CollisionResult result = MthUtils.sweptAABB(myBox, box = box.move(pos), movement);
                if (result == null || result.entryTime < 0.0) continue;
                if (earliestCollision == null) {
                    earliestCollision = result;
                    hitPos = pos;
                    continue;
                }
                if (result.entryTime == earliestCollision.entryTime) {
                    Vec3 collidedPos = myPos.add(movement.scale(result.entryTime));
                    if (!(pos.distToCenterSqr((Position)collidedPos) < hitPos.distToCenterSqr((Position)collidedPos))) continue;
                    earliestCollision = result;
                    hitPos = pos;
                    continue;
                }
                if (!(result.entryTime < earliestCollision.entryTime)) continue;
                earliestCollision = result;
                hitPos = pos;
            }
        }
        if (earliestCollision != null && earliestCollision.entryTime < 1.0) {
            double entryTime = earliestCollision.entryTime - (double)1.0E-5f;
            movement = movement.scale(entryTime);
            Vec3 finalPos = myPos.add(movement);
            return new BlockHitResult(finalPos, earliestCollision.direction.getOpposite(), hitPos, false);
        }
        Vec3 missPos = myPos.add(movement);
        return BlockHitResult.miss((Vec3)missPos, (Direction)Direction.UP, (BlockPos)BlockPos.containing((Position)missPos));
    }

    private static CollisionResult sweptAABB(AABB movingBox, AABB staticBox, Vec3 movement) {
        double exitZ;
        double entryZ;
        double exitY;
        double entryY;
        double exitX;
        double entryX;
        if (movement.x > 0.0) {
            entryX = (staticBox.minX - movingBox.maxX) / movement.x;
            exitX = (staticBox.maxX - movingBox.minX) / movement.x;
        } else if (movement.x < 0.0) {
            entryX = (staticBox.maxX - movingBox.minX) / movement.x;
            exitX = (staticBox.minX - movingBox.maxX) / movement.x;
        } else {
            entryX = Double.NEGATIVE_INFINITY;
            exitX = Double.POSITIVE_INFINITY;
        }
        if (movement.y > 0.0) {
            entryY = (staticBox.minY - movingBox.maxY) / movement.y;
            exitY = (staticBox.maxY - movingBox.minY) / movement.y;
        } else if (movement.y < 0.0) {
            entryY = (staticBox.maxY - movingBox.minY) / movement.y;
            exitY = (staticBox.minY - movingBox.maxY) / movement.y;
        } else {
            entryY = Double.NEGATIVE_INFINITY;
            exitY = Double.POSITIVE_INFINITY;
        }
        if (movement.z > 0.0) {
            entryZ = (staticBox.minZ - movingBox.maxZ) / movement.z;
            exitZ = (staticBox.maxZ - movingBox.minZ) / movement.z;
        } else if (movement.z < 0.0) {
            entryZ = (staticBox.maxZ - movingBox.minZ) / movement.z;
            exitZ = (staticBox.minZ - movingBox.maxZ) / movement.z;
        } else {
            entryZ = Double.NEGATIVE_INFINITY;
            exitZ = Double.POSITIVE_INFINITY;
        }
        double entryTime = Math.max(Math.max(entryX, entryY), entryZ);
        double exitTime = Math.min(Math.min(exitX, exitY), exitZ);
        if (entryTime > exitTime || entryX < 0.0 && entryY < 0.0 && entryZ < 0.0 || entryX > 1.0 || entryY > 1.0 || entryZ > 1.0) {
            return null;
        }
        Direction collisionDirection = entryX > entryY && entryX > entryZ ? (movement.x > 0.0 ? Direction.EAST : Direction.WEST) : (entryY > entryZ ? (movement.y > 0.0 ? Direction.UP : Direction.DOWN) : (movement.z > 0.0 ? Direction.SOUTH : Direction.NORTH));
        return new CollisionResult(entryTime, collisionDirection);
    }

    public static String sha256Digest(List<String> tokens) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (String t : tokens) {
                md.update(t.getBytes(StandardCharsets.UTF_8));
                md.update((byte)31);
            }
            byte[] d = md.digest();
            StringBuilder sb = new StringBuilder(d.length * 2);
            for (byte b : d) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return Integer.toHexString(tokens.toString().hashCode());
        }
    }

    private record CollisionResult(double entryTime, Direction direction) {
    }
}

