/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;
import twilightforest.TFRegistries;
import twilightforest.world.components.layer.BiomeDensitySource;

public class NoiseDensityRouter
implements DensityFunction.SimpleFunction {
    public static final MapCodec<NoiseDensityRouter> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RegistryFileCodec.create(TFRegistries.Keys.BIOME_TERRAIN_DATA, BiomeDensitySource.CODEC, (boolean)false).fieldOf("terrain_source").forGetter(NoiseDensityRouter::biomeDensitySourceHolder), (App)Codec.doubleRange((double)-64.0, (double)0.0).fieldOf("lower_density_bound").forGetter(NoiseDensityRouter::lowerDensityBound), (App)Codec.doubleRange((double)0.0, (double)64.0).fieldOf("upper_density_bound").forGetter(NoiseDensityRouter::upperDensityBound), (App)Codec.doubleRange((double)0.0, (double)32.0).orElse((Object)8.0).fieldOf("depth_scalar").forGetter(NoiseDensityRouter::depthScalar)).apply((Applicative)inst, NoiseDensityRouter::new));
    public static final KeyDispatchDataCodec<NoiseDensityRouter> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    private final Holder<BiomeDensitySource> biomeDensitySourceHolder;
    private final double lowerDensityBound;
    private final double upperDensityBound;
    private final double depthScalar;

    public NoiseDensityRouter(Holder<BiomeDensitySource> biomeDensitySource, double lowerDensityBound, double upperDensityBound, double depthScalar) {
        this.biomeDensitySourceHolder = biomeDensitySource;
        this.lowerDensityBound = lowerDensityBound;
        this.upperDensityBound = upperDensityBound;
        this.depthScalar = depthScalar;
    }

    public double compute(DensityFunction.FunctionContext context) {
        return this.computeTerrain((DensityFunction.FunctionContext)context).scale;
    }

    @NotNull
    public BiomeDensitySource.DensityData computeTerrain(DensityFunction.FunctionContext context) {
        return ((BiomeDensitySource)this.biomeDensitySourceHolder.value()).sampleTerrain(context.blockX(), context.blockZ(), context);
    }

    public double minValue() {
        return this.lowerDensityBound;
    }

    public double maxValue() {
        return this.upperDensityBound;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return KEY_CODEC;
    }

    public Holder<BiomeDensitySource> biomeDensitySourceHolder() {
        return this.biomeDensitySourceHolder;
    }

    public double lowerDensityBound() {
        return this.lowerDensityBound;
    }

    public double upperDensityBound() {
        return this.upperDensityBound;
    }

    public double depthScalar() {
        return this.depthScalar;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ChunkCachedNoiseDensityRouter(this.biomeDensitySourceHolder, this.lowerDensityBound, this.upperDensityBound, this.depthScalar));
    }

    public static class ChunkCachedNoiseDensityRouter
    extends NoiseDensityRouter {
        private final BiomeDensitySource biomeDensitySource;
        private final BiomeDensitySource.DensityData[] horizontalCache = new BiomeDensitySource.DensityData[256];

        public ChunkCachedNoiseDensityRouter(Holder<BiomeDensitySource> biomeDensitySource, double lowerDensityBound, double upperDensityBound, double depthScalar) {
            super(biomeDensitySource, lowerDensityBound, upperDensityBound, depthScalar);
            this.biomeDensitySource = (BiomeDensitySource)biomeDensitySource.value();
        }

        @Override
        @NotNull
        public BiomeDensitySource.DensityData computeTerrain(DensityFunction.FunctionContext context) {
            int xInChunk = SectionPos.sectionRelative((int)context.blockX());
            int zInChunk = SectionPos.sectionRelative((int)context.blockZ());
            int arrayCoord = zInChunk + (xInChunk << 4);
            BiomeDensitySource.DensityData dataColumn = this.horizontalCache[arrayCoord];
            if (dataColumn == null) {
                this.horizontalCache[arrayCoord] = dataColumn = this.biomeDensitySource.sampleTerrain(context.blockX(), context.blockZ(), context);
            }
            return dataColumn;
        }
    }
}

