/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import twilightforest.TFRegistries;
import twilightforest.entity.MagicPaintingVariant;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFDataSerializers;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.custom.MagicPaintingVariants;

public class MagicPainting
extends HangingEntity {
    private static final EntityDataAccessor<Holder<MagicPaintingVariant>> MAGIC_PAINTING_VARIANT = SynchedEntityData.defineId(MagicPainting.class, (EntityDataSerializer)((EntityDataSerializer)TFDataSerializers.MAGIC_PAINTING_VARIANT.value()));

    public MagicPainting(EntityType<? extends MagicPainting> entityType, Level level) {
        super(entityType, level);
    }

    private MagicPainting(Level level, BlockPos pos) {
        super((EntityType)TFEntities.MAGIC_PAINTING.get(), level, pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MAGIC_PAINTING_VARIANT, (Object)this.getReg().getHolderOrThrow(MagicPaintingVariants.DEFAULT));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (MAGIC_PAINTING_VARIANT.equals(pKey)) {
            this.recalculateBoundingBox();
        }
    }

    public void setVariant(Holder<MagicPaintingVariant> variant) {
        this.getEntityData().set(MAGIC_PAINTING_VARIANT, variant);
    }

    public Holder<MagicPaintingVariant> getVariant() {
        return (Holder)this.getEntityData().get(MAGIC_PAINTING_VARIANT);
    }

    public static Optional<MagicPainting> create(Level level, BlockPos pos, Direction direction) {
        MagicPainting magicPainting = new MagicPainting(level, pos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        level.registryAccess().registryOrThrow(TFRegistries.Keys.MAGIC_PAINTINGS).holders().forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        magicPainting.setDirection(direction);
        list.removeIf(variant -> {
            magicPainting.setVariant((Holder<MagicPaintingVariant>)variant);
            return !magicPainting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int biggestPossibleArea = list.stream().mapToInt(MagicPainting::variantArea).max().orElse(0);
        list.removeIf(variantArea -> MagicPainting.variantArea((Holder<MagicPaintingVariant>)variantArea) < biggestPossibleArea);
        Optional optional = Util.getRandomSafe(list, (RandomSource)magicPainting.random);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        magicPainting.setVariant((Holder<MagicPaintingVariant>)((Holder)optional.get()));
        magicPainting.setDirection(direction);
        return Optional.of(magicPainting);
    }

    private static int variantArea(Holder<MagicPaintingVariant> variant) {
        return MagicPainting.variantArea((MagicPaintingVariant)variant.value());
    }

    private static int variantArea(MagicPaintingVariant variant) {
        return variant.width() * variant.height();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        ResourceLocation location = this.getReg().getKey((Object)((MagicPaintingVariant)this.getVariant().value()));
        if (location != null) {
            tag.putString("variant", location.toString());
        }
        tag.putByte("facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        ResourceLocation location;
        if (tag.contains("variant") && (location = ResourceLocation.tryParse((String)tag.getString("variant"))) != null) {
            this.setVariant((Holder<MagicPaintingVariant>)((Holder)this.getReg().getHolder(location).orElse(this.getReg().getHolderOrThrow(MagicPaintingVariants.DEFAULT))));
        }
        this.direction = Direction.from2DDataValue((int)tag.getByte("facing"));
        super.readAdditionalSaveData(tag);
        this.setDirection(this.direction);
    }

    protected Registry<MagicPaintingVariant> getReg() {
        return this.registryAccess().registryOrThrow(TFRegistries.Keys.MAGIC_PAINTINGS);
    }

    protected AABB calculateBoundingBox(BlockPos pos, Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos).relative(direction, -0.46875);
        MagicPaintingVariant variant = (MagicPaintingVariant)this.getVariant().value();
        double widthOffset = this.offsetForPaintingSize(variant.width());
        double heightOffset = this.offsetForPaintingSize(variant.height());
        Vec3 vec31 = vec3.relative(direction.getCounterClockWise(), widthOffset).relative(Direction.UP, heightOffset);
        Direction.Axis axis = direction.getAxis();
        double scale = 0.0625;
        double x = axis == Direction.Axis.X ? 0.0625 : (double)variant.width() * scale;
        double y = (double)variant.height() * scale;
        double z = axis == Direction.Axis.Z ? 0.0625 : (double)variant.width() * scale;
        return AABB.ofSize((Vec3)vec31, (double)x, (double)y, (double)z);
    }

    private double offsetForPaintingSize(int size) {
        return size % 32 == 0 ? 0.5 : 0.0;
    }

    public void dropItem(@Nullable Entity entity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) {
                    return;
                }
            }
            this.spawnAtLocation(this.getPickResult());
        }
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    public void moveTo(double x, double y, double z, float yaw, float pitch) {
        this.setPos(x, y, z);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.setPos(x, y, z);
    }

    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf((Vec3i)this.pos);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setDirection(Direction.from3DDataValue((int)packet.getData()));
    }

    @NotNull
    public ItemStack getPickResult() {
        ItemStack itemStack = new ItemStack((ItemLike)TFItems.MAGIC_PAINTING.get());
        itemStack.set(TFDataComponents.MAGIC_PAINTING_VARIANT, this.getVariant());
        return itemStack;
    }

    public void setDirection(Direction faceDirection) {
        super.setDirection(faceDirection);
    }
}

