/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.helpers;

import java.text.ChoiceFormat;
import java.util.List;
import twilightforest.TwilightForestMod;
import twilightforest.data.helpers.LangFormatSplitter;

public class LangConversionHelper {
    private static final String normal = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,.?!;\"'`&_^()[]{}<>";
    private static final char[] upside_down = "\u0250q\u0254p\u01dd\u025f\u1d77\u0265\u1d09\u027e\u029e\ua781\u026fuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u0550\ua7b0\ua780WNO\u0500\ua779\u1d1aS\u27d8\u2229\u039bMX\u2144Z0\u295d\u1614\u0190\u07c8\u03db9\u312586'\u02d9\u00bf\u00a1\u061b\u201e,,\u214b\u203ev)(][}{><".toCharArray();

    public static char flip(char c) {
        int index = normal.indexOf(c);
        return index == -1 ? c : upside_down[index];
    }

    public static String convertFormattingComponent(LangFormatSplitter.FormatComponent component, int curIndex, int numArguments) {
        String ending;
        if (component instanceof LangFormatSplitter.MessageFormatComponent) {
            LangFormatSplitter.MessageFormatComponent messageFormatComponent = (LangFormatSplitter.MessageFormatComponent)component;
            return LangConversionHelper.convertMessageFormatCode(messageFormatComponent);
        }
        String formattingCode = component.contents();
        int storedIndex = curIndex;
        String[] split = formattingCode.split("\\$");
        if (split.length == 2) {
            ending = split[1];
            storedIndex = Integer.parseInt(split[0].substring(1));
        } else {
            ending = formattingCode.substring(1);
        }
        if (storedIndex == numArguments - curIndex + 1) {
            return "%" + ending;
        }
        return "%" + storedIndex + "$" + ending;
    }

    public static String convertMessageFormatCode(LangFormatSplitter.MessageFormatComponent component) {
        String formatStyle = component.getFormatStyle();
        if (formatStyle != null && component.isChoice()) {
            String newFormatStyle = LangConversionHelper.invertChoice(formatStyle);
            try {
                new ChoiceFormat(newFormatStyle);
            }
            catch (IllegalArgumentException e) {
                TwilightForestMod.LOGGER.warn("Failed to convert '{}' to an upside down choice format. Got: '{}' which was invalid.", (Object)formatStyle, (Object)newFormatStyle);
                return component.contents();
            }
            return "{" + component.getArgumentIndex() + "," + component.getFormatType() + "," + newFormatStyle + "}";
        }
        return component.contents();
    }

    public static String invertChoice(String choice) {
        StringBuilder converted = new StringBuilder();
        StringBuilder literalBuilder = new StringBuilder();
        StringBuilder textBuilder = new StringBuilder();
        char[] exploded = choice.toCharArray();
        int leftBrackets = 0;
        boolean inLiteral = true;
        for (char c : exploded) {
            if (inLiteral) {
                literalBuilder.append(c);
                if (c != '#' && c != '<' && c != '\u2264') continue;
                inLiteral = false;
                converted.append((CharSequence)literalBuilder);
                literalBuilder = new StringBuilder();
                continue;
            }
            if (c == '{') {
                ++leftBrackets;
            } else if (c == '}') {
                --leftBrackets;
            } else if (c == '|' && leftBrackets == 0) {
                inLiteral = true;
                converted.append(LangConversionHelper.convertComponents(LangFormatSplitter.splitMessageFormat(textBuilder.toString())));
                textBuilder = new StringBuilder();
            }
            if (inLiteral) {
                literalBuilder.append(c);
                continue;
            }
            textBuilder.append(c);
        }
        if (inLiteral) {
            converted.append((CharSequence)literalBuilder);
        } else {
            converted.append(LangConversionHelper.convertComponents(LangFormatSplitter.splitMessageFormat(textBuilder.toString())));
        }
        return converted.toString();
    }

    public static String convertComponents(List<LangFormatSplitter.Component> splitText) {
        int numArguments = (int)splitText.stream().filter(component -> component instanceof LangFormatSplitter.FormatComponent).count();
        StringBuilder converted = new StringBuilder();
        int curIndex = numArguments;
        for (int i = splitText.size() - 1; i >= 0; --i) {
            LangFormatSplitter.Component component2 = splitText.get(i);
            if (component2 instanceof LangFormatSplitter.FormatComponent) {
                LangFormatSplitter.FormatComponent formatComponent = (LangFormatSplitter.FormatComponent)component2;
                converted.append(LangConversionHelper.convertFormattingComponent(formatComponent, curIndex--, numArguments));
                continue;
            }
            char[] toConvertArr = component2.contents().toCharArray();
            for (int j = toConvertArr.length - 1; j >= 0; --j) {
                converted.append(LangConversionHelper.flip(toConvertArr[j]));
            }
        }
        return new String(converted);
    }
}

