/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import twilightforest.beanification.Component;

@Component
public class MapLocatorCommand {
    private final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(info -> net.minecraft.network.chat.Component.translatableEscape((String)"commands.locate.structure.invalid", (Object[])new Object[]{info}));
    private final DynamicCommandExceptionType ERROR_STRUCTURE_NOT_FOUND = new DynamicCommandExceptionType(info -> net.minecraft.network.chat.Component.translatableEscape((String)"commands.locate.structure.not_found", (Object[])new Object[]{info}));

    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"map_locator").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(context -> this.run((CommandContext<CommandSourceStack>)context, Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), false))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> this.run((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"player"), false))).then(Commands.argument((String)"skip_known_structures", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.run((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"skip_known_structures"))))));
    }

    private int run(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, boolean skipKnownStructures) throws CommandSyntaxException {
        ResourceOrTagKeyArgument.Result structure = ResourceOrTagKeyArgument.getResourceOrTagKey(context, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)this.ERROR_STRUCTURE_INVALID);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Registry registry = source.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE);
        HolderSet holderset = (HolderSet)LocateCommand.getHolders((ResourceOrTagKeyArgument.Result)structure, (Registry)registry).orElseThrow(() -> this.ERROR_STRUCTURE_INVALID.create((Object)structure.asPrintable()));
        BlockPos blockpos = BlockPos.containing((Position)source.getPosition());
        ServerLevel serverlevel = source.getLevel();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        Pair pair = serverlevel.getChunkSource().getGenerator().findNearestMapStructure(serverlevel, holderset, blockpos, 100, skipKnownStructures);
        stopwatch.stop();
        if (pair == null) {
            throw this.ERROR_STRUCTURE_NOT_FOUND.create((Object)structure.asPrintable());
        }
        BlockPos foundPos = (BlockPos)pair.getFirst();
        ItemStack itemstack = MapItem.create((Level)serverlevel, (int)foundPos.getX(), (int)foundPos.getZ(), (byte)4, (boolean)true, (boolean)true);
        MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)foundPos, (String)"+", (Holder)MapDecorationTypes.RED_X);
        for (ServerPlayer player : players) {
            player.getInventory().add(itemstack.copy());
        }
        return LocateCommand.showLocateResult((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)structure, (BlockPos)foundPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
    }
}

