/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block;

import com.google.common.base.MoreObjects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.entity.ReactorDebrisBlockEntity;
import twilightforest.client.renderer.block.ReactorDebrisRenderer;

public class ReactorDebrisModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<ResourceLocation> TEXTURE_FOR_PARTICLE = new ModelProperty();

    public ReactorDebrisModel(BakedModel defaultModel) {
        super(defaultModel);
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        ReactorDebrisBlockEntity reactorDebrisBlockEntity;
        block3: {
            block2: {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof ReactorDebrisBlockEntity)) break block2;
                reactorDebrisBlockEntity = (ReactorDebrisBlockEntity)blockEntity;
                if (level instanceof ClientLevel) break block3;
            }
            return modelData.derive().with(TEXTURE_FOR_PARTICLE, (Object)ReactorDebrisBlockEntity.DEFAULT_TEXTURE).build();
        }
        ClientLevel clientLevel = (ClientLevel)level;
        ResourceLocation textureForParticle = reactorDebrisBlockEntity.textures[clientLevel.random.nextInt(reactorDebrisBlockEntity.textures.length)];
        return modelData.derive().with(TEXTURE_FOR_PARTICLE, (Object)textureForParticle).build();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(ModelData data) {
        ResourceLocation texturePath = (ResourceLocation)MoreObjects.firstNonNull((Object)((ResourceLocation)data.get(TEXTURE_FOR_PARTICLE)), (Object)ReactorDebrisBlockEntity.DEFAULT_TEXTURE);
        return ReactorDebrisRenderer.getSprite(texturePath);
    }
}

