/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.ConnectableRotatedPillarBlock;

public class WallPillarBlock
extends ConnectableRotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    protected static final VoxelShape UP_SHAPE = Block.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape WEST_FLAT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_FLAT = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_FLAT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape UP_FLAT = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_FLAT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SOUTH_FLAT = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public WallPillarBlock(BlockBehaviour.Properties properties, double width, double height) {
        super(properties, width);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = BASE_SHAPE;
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        } else if (axis.equals((Object)Direction.Axis.Y)) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_FLAT);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        } else if (axis.equals((Object)Direction.Axis.Y)) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_FLAT);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        } else if (axis.equals((Object)Direction.Axis.Z)) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_FLAT);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        } else if (axis.equals((Object)Direction.Axis.Z)) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_FLAT);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        } else if (axis.equals((Object)Direction.Axis.X)) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_FLAT);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        } else if (axis.equals((Object)Direction.Axis.X)) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_FLAT);
        }
        return shape;
    }

    @Override
    public boolean canConnectTo(Direction.Axis thisAxis, Direction facing, BlockState facingState, boolean solidSide) {
        return facingState.getBlock() instanceof WallPillarBlock && (facing.getAxis() == thisAxis || facing.getAxis() == facingState.getValue((Property)AXIS));
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return super.getBlockSupportShape(pState, pLevel, pPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{WATERLOGGED}));
    }
}

