/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty X = BooleanProperty.create((String)"x");
    public static final BooleanProperty Y = BooleanProperty.create((String)"y");
    public static final BooleanProperty Z = BooleanProperty.create((String)"z");
    protected static final VoxelShape X_SHAPE = Block.box((double)0.0, (double)6.5, (double)6.5, (double)16.0, (double)9.5, (double)9.5);
    protected static final VoxelShape Y_SHAPE = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    protected static final VoxelShape Z_SHAPE = Block.box((double)6.5, (double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)Y, (Comparable)Boolean.valueOf(true))).setValue((Property)X, (Comparable)Boolean.valueOf(false))).setValue((Property)Z, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canConnectTo(BlockState state, Direction dir, LevelReader level, BlockPos pos) {
        if (dir == Direction.DOWN) {
            return false;
        }
        return state.getBlock() instanceof LeavesBlock || state.getBlock() instanceof RopeBlock && RopeBlock.hasAxis(state, dir.getAxis()) || state.isFaceSturdy((BlockGetter)level, pos, dir.getOpposite(), SupportType.CENTER);
    }

    public static boolean hasAxis(BlockState state, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> (Boolean)state.getValue((Property)X);
            case Direction.Axis.Y -> (Boolean)state.getValue((Property)Y);
            case Direction.Axis.Z -> (Boolean)state.getValue((Property)Z);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, Y, X, Z});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)state.getValue((Property)X)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)X_SHAPE);
        }
        if (((Boolean)state.getValue((Property)Y)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Y_SHAPE);
        }
        if (((Boolean)state.getValue((Property)Z)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Z_SHAPE);
        }
        return shape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)state.getValue((Property)X)).booleanValue() && context.isAbove(X_SHAPE, pos, false) && !context.isDescending()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)X_SHAPE);
        }
        if (((Boolean)state.getValue((Property)Z)).booleanValue() && context.isAbove(Z_SHAPE, pos, false) && !context.isDescending()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Z_SHAPE);
        }
        return shape;
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return context.getItemInHand().is(this.asItem());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        Direction direction = context.getClickedFace();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(blockpos).getType() == Fluids.WATER))).setValue((Property)X, (Comparable)Boolean.valueOf(direction.getAxis() == Direction.Axis.X))).setValue((Property)Y, (Comparable)Boolean.valueOf(direction.getAxis() == Direction.Axis.Y))).setValue((Property)Z, (Comparable)Boolean.valueOf(direction.getAxis() == Direction.Axis.Z));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState otherState, boolean isMoving) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean flag = true;
        int drops = 0;
        BlockState newState = state;
        if (((Boolean)state.getValue((Property)X)).booleanValue()) {
            if (!this.checkConnection((LevelReader)level, pos, Direction.WEST) && !this.checkConnection((LevelReader)level, pos, Direction.EAST)) {
                newState = (BlockState)newState.setValue((Property)X, (Comparable)Boolean.valueOf(false));
                ++drops;
            } else {
                flag = false;
            }
        }
        if (((Boolean)state.getValue((Property)Y)).booleanValue()) {
            if (!this.checkConnection((LevelReader)level, pos, Direction.UP)) {
                newState = (BlockState)newState.setValue((Property)Y, (Comparable)Boolean.valueOf(false));
                ++drops;
            } else {
                flag = false;
            }
        }
        if (((Boolean)state.getValue((Property)Z)).booleanValue()) {
            if (!this.checkConnection((LevelReader)level, pos, Direction.NORTH) && !this.checkConnection((LevelReader)level, pos, Direction.SOUTH)) {
                newState = (BlockState)newState.setValue((Property)Z, (Comparable)Boolean.valueOf(false));
                ++drops;
            } else {
                flag = false;
            }
        }
        if (flag) {
            level.destroyBlock(pos, true);
        } else if (drops > 0) {
            level.setBlockAndUpdate(pos, newState);
            for (int i = 0; i < drops; ++i) {
                RopeBlock.dropResources((BlockState)this.defaultBlockState(), (Level)level, (BlockPos)pos);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)X)).booleanValue()) {
            if (RopeBlock.canConnectTo(level.getBlockState(pos.relative(Direction.WEST)), Direction.WEST, level, pos)) {
                return true;
            }
            if (RopeBlock.canConnectTo(level.getBlockState(pos.relative(Direction.EAST)), Direction.EAST, level, pos)) {
                return true;
            }
        }
        if (((Boolean)state.getValue((Property)Y)).booleanValue() && RopeBlock.canConnectTo(level.getBlockState(pos.relative(Direction.UP)), Direction.UP, level, pos)) {
            return true;
        }
        if (((Boolean)state.getValue((Property)Z)).booleanValue()) {
            if (RopeBlock.canConnectTo(level.getBlockState(pos.relative(Direction.NORTH)), Direction.NORTH, level, pos)) {
                return true;
            }
            return RopeBlock.canConnectTo(level.getBlockState(pos.relative(Direction.SOUTH)), Direction.SOUTH, level, pos);
        }
        return false;
    }

    protected boolean checkConnection(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            if (!level.getBlockState((BlockPos)mutable).is((Block)this)) {
                return true;
            }
            mutable.move(dir);
        } while (RopeBlock.canConnectTo(level.getBlockState((BlockPos)mutable), dir, level, (BlockPos)mutable));
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)((BlockState)state.setValue((Property)X, (Comparable)((Boolean)state.getValue((Property)Z)))).setValue((Property)Z, (Comparable)((Boolean)state.getValue((Property)X)));
        }
        return state;
    }
}

