/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.HatStandModel;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class HatStandRenderer
extends LivingEntityRenderer<HatStandEntity, HatStandModel> {
    public HatStandRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HatStandModel(context.bakeLayer(ClientRegistry.HAT_STAND_MODEL)), 0.0f);
        ModelPart modelPart = context.bakeLayer(ClientRegistry.HAT_STAND_MODEL_ARMOR);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(modelPart), new HumanoidModel(modelPart), context.getModelManager()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
    }

    protected void setupRotations(HatStandEntity entity, PoseStack poseStack, float bob, float yBodyRot, float partialTicks, float scale) {
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yBodyRot));
        float f = (float)(entity.level().getGameTime() - entity.lastHit) + partialTicks;
        if (f < 5.0f) {
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    public Vec3 getRenderOffset(HatStandEntity entity, float partialTicks) {
        if (entity.isNoBasePlate()) {
            return new Vec3(0.0, -0.0625, 0.0);
        }
        return super.getRenderOffset((Entity)entity, partialTicks);
    }

    protected boolean shouldShowName(HatStandEntity entity) {
        double d = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
        float f = entity.isCrouching() ? 32.0f : 64.0f;
        return d < (double)(f * f) && entity.isCustomNameVisible();
    }

    public ResourceLocation getTextureLocation(HatStandEntity entity) {
        return ModTextures.HAT_STAND;
    }
}

