/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.api;

import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CapturedMobInstance<T extends Entity> {
    protected final T entity;

    protected CapturedMobInstance(T entity) {
        this.entity = entity;
    }

    @Nullable
    public T getEntityForRenderer() {
        return this.entity;
    }

    public void containerTick(Level world, BlockPos pos, float entityScale, CompoundTag entityData) {
    }

    public ItemInteractionResult onPlayerInteract(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, CompoundTag entityData) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onContainerWaterlogged(boolean waterlogged, float containerWidth, float containerHeight) {
        if (this.entity instanceof WaterAnimal && this.entity.isInWater() != waterlogged) {
            ((Entity)this.entity).wasTouchingWater = waterlogged;
            Pair<Float, Float> dim = MobContainer.calculateMobDimensionsForContainer(this.entity, containerWidth, containerHeight, waterlogged);
            double py = (double)((Float)dim.getRight()).floatValue() + 1.0E-4;
            this.entity.setPos(this.entity.getX(), py, this.entity.getZ());
            ((Entity)this.entity).yOld = py;
        }
    }
}

