/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SqueezerShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SqueezerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(2, 1, 2);
    private static final MultiblockFace ITEM_OUTPUT = new MultiblockFace(2, 1, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace FLUID_OUTPUT = new MultiblockFace(3, 0, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing(ITEM_OUTPUT);
    private static final CapabilityPosition FLUID_OUTPUT_CAP = CapabilityPosition.opposing(FLUID_OUTPUT);
    private static final BlockPos ITEM_INPUT = new BlockPos(0, 1, 0);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final int NUM_SLOTS = 11;
    public static final int NUM_INPUT_SLOTS = 8;
    public static final int OUTPUT_SLOT = 8;
    public static final int TANK_CAPACITY = 24000;
    public static final int ENERGY_CAPACITY = 16000;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        this.enqueueProcesses(state, context.getLevel().getRawLevel());
        if (context.getLevel().shouldTickModulo(8)) {
            this.handleItemOutput(context);
        }
        FluidUtils.multiblockFluidOutput(state.fluidOutput.get(), state.tank, 9, 10, state.inventory);
    }

    private void enqueueProcesses(State state, Level level) {
        int n;
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        int[] usedInvSlots = new int[8];
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof MultiblockProcessInMachine)) continue;
            int[] nArray = ((MultiblockProcessInMachine)process).getInputSlots();
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                int n2 = i2 = nArray[i];
                usedInvSlots[n2] = usedInvSlots[n2] + 1;
            }
        }
        Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
        Arrays.sort(preferredSlots, 0, 8, Comparator.comparingInt(arg0 -> usedInvSlots[arg0]));
        Integer[] integerArray = preferredSlots;
        int n3 = integerArray.length;
        for (n = 0; n < n3; ++n) {
            int slot = integerArray[n];
            ItemStack stack = state.inventory.getStackInSlot(slot);
            if (stack.getCount() <= usedInvSlots[slot]) continue;
            stack = stack.copy();
            stack.shrink(usedInvSlots[slot]);
            RecipeHolder<SqueezerRecipe> recipe = SqueezerRecipe.findRecipe(level, stack);
            if (recipe == null) continue;
            state.processor.addProcessToQueue(new MultiblockProcessInMachine<SqueezerRecipe>(recipe, slot), level, false);
        }
    }

    private void handleItemOutput(IMultiblockContext<State> ctx) {
        State state = ctx.getState();
        ItemStack fullOutputStack = state.inventory.getStackInSlot(8);
        if (fullOutputStack.isEmpty()) {
            return;
        }
        ItemStack stack = fullOutputStack.copyWithCount(1);
        ItemStack remaining = Utils.insertStackIntoInventory(state.itemOutput, stack, false);
        if (remaining.isEmpty()) {
            fullOutputStack.shrink(1);
            ctx.markMasterDirty();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.active && (double)state.animation_piston < 0.6875) {
            state.animation_piston = Math.min(0.6875f, state.animation_piston + 0.03125f);
        } else if (state.active) {
            state.animation_piston = state.animation_down ? Math.max(0.0f, state.animation_piston - 0.03125f) : Math.min(0.6875f, state.animation_piston + 0.03125f);
            if (state.animation_piston <= 0.0f && state.animation_down) {
                state.animation_down = false;
            } else if ((double)state.animation_piston >= 0.6875 && !state.animation_down) {
                state.animation_down = true;
            }
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_POS, state -> state.energy);
        register.registerAtOrNull(Capabilities.FluidHandler.BLOCK, FLUID_OUTPUT_CAP, state -> state.fluidOutputCap);
        register.register(Capabilities.ItemHandler.BLOCK, (state, position) -> {
            if (ITEM_INPUT.equals((Object)position.posInMultiblock())) {
                return state.itemInputCap;
            }
            if (ITEM_OUTPUT_CAP.equals(position)) {
                return state.itemOutputCap;
            }
            return null;
        });
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SqueezerShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(state -> Utils.calcRedstoneFromInventory(8, (IItemHandler)state.inventory), REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<SqueezerRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        private final FluidTank tank = new FluidTank(24000);
        private final SlotwiseItemHandler inventory;
        private final MultiblockProcessor.InMachineProcessor<SqueezerRecipe> processor;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean active;
        public float animation_piston = 0.0f;
        public boolean animation_down = true;
        private final Supplier<@Nullable IItemHandler> itemOutput;
        private final Supplier<@Nullable IFluidHandler> fluidOutput;
        private final IFluidHandler fluidOutputCap;
        private final IItemHandler itemInputCap;
        private final IItemHandler itemOutputCap;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 8), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.FLUID_INPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1)), markDirty);
            this.processor = new MultiblockProcessor.InMachineProcessor<SqueezerRecipe>(8, 0.0f, 8, markDirty, SqueezerRecipe.RECIPES::getById);
            this.itemOutput = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, ITEM_OUTPUT);
            this.fluidOutput = ctx.getCapabilityAt(Capabilities.FluidHandler.BLOCK, FLUID_OUTPUT);
            this.fluidOutputCap = ArrayFluidHandler.drainOnly((IFluidTank)this.tank, markDirty);
            this.itemInputCap = new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(0, 8));
            this.itemOutputCap = new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(8, 9));
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.itemInputCap, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.itemOutputCap, MachineInterfaceHandler.BASIC_ITEM_OUT), new MachineInterfaceHandler.MachineCheckImplementation<IFluidHandler>(this.fluidOutputCap, MachineInterfaceHandler.BASIC_FLUID_OUT), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.put("processor", this.processor.toNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.energy.deserializeNBT(provider, nbt.get("energy"));
            this.tank.readFromNBT(provider, nbt.getCompound("tank"));
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.processor.fromNBT(nbt.get("processor"), (getRecipe, data, p) -> new MultiblockProcessInMachine(getRecipe, data), provider);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.active = nbt.getBoolean("active");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        public int[] getOutputTanks() {
            return new int[]{0};
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tank};
        }

        public FluidTank getTank() {
            return this.tank;
        }

        @Override
        public int[] getOutputSlots() {
            return new int[]{8};
        }
    }
}

