/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.mixin.client;

import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.ChatEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientPacketListener.class})
public class ClientPacketListenerMixin {
    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;resetPos()V", shift=At.Shift.AFTER)})
    public void journeymap_handleLogin(ClientboundLoginPacket packet, CallbackInfo callbackInfo) {
        ClientPacketListenerMixin.updateWorldId(packet.commonPlayerSpawnInfo().seed());
    }

    @Inject(method={"handleRespawn(Lnet/minecraft/network/protocol/game/ClientboundRespawnPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;resetPos()V", shift=At.Shift.AFTER)})
    public void journeymap_handleRespawn(ClientboundRespawnPacket packet, CallbackInfo callbackInfo) {
        ClientPacketListenerMixin.updateWorldId(packet.commonPlayerSpawnInfo().seed());
    }

    @Unique
    private static void updateWorldId(Long seed) {
        boolean useSeed = JourneymapClient.getInstance().getCoreProperties().seedId.get();
        boolean useIp = JourneymapClient.getInstance().getCoreProperties().serverIp.get();
        if (!Minecraft.getInstance().hasSingleplayerServer() && (useSeed || useIp)) {
            String ip = Minecraft.getInstance().player.connection.getConnection().getRemoteAddress().toString();
            Object id = useSeed ? "id_" + seed : "";
            id = (String)id + (useIp && useSeed ? "_" : "");
            id = (String)id + (String)(useIp ? "ip_" + ip : "");
            JourneymapClient.getInstance().setCurrentWorldId((String)id);
        }
    }

    @Inject(method={"handleDisguisedChat(Lnet/minecraft/network/protocol/game/ClientboundDisguisedChatPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/chat/ChatListener;handleDisguisedChatMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/ChatType$Bound;)V", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void journeymap_handleDisguisedChat_onClientChatEventReceived(ClientboundDisguisedChatPacket clientboundSystemChatPacket, CallbackInfo ci) {
        Component newMessage;
        Component incomingMessage = clientboundSystemChatPacket.message();
        if (incomingMessage != (newMessage = ChatEventHandler.getInstance().onClientChatEventReceived(incomingMessage)) && newMessage != null) {
            Minecraft.getInstance().getChatListener().handleDisguisedChatMessage(newMessage, clientboundSystemChatPacket.chatType());
            ci.cancel();
        }
    }
}

