/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.menu;

import java.util.ArrayList;
import journeymap.api.client.impl.ModPopupMenuImpl;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.PopupMenu;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.ClientWaypointImpl;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;

public class FullScreenPopupMenu
extends PopupMenu {
    public FullScreenPopupMenu(PopupMenu parent) {
        super(parent);
    }

    public FullScreenPopupMenu(Screen parent) {
        super(parent);
    }

    public void displayBasicOptions(BlockPos blockPos) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        if (CustomEventDispatcher.getInstance().popupMenuEvent((Fullscreen)this.parent, menu)) {
            this.displayOptions(blockPos, menu);
        }
    }

    public void displayWaypointOptions(BlockPos blockPos, ClientWaypointImpl wp) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        if (CustomEventDispatcher.getInstance().popupWaypointMenuEvent((Fullscreen)this.parent, menu, wp)) {
            this.displayOptions(blockPos, menu);
        }
    }

    public void displayOptions(BlockPos blockPos, ModPopupMenu popupMenu) {
        ModPopupMenuImpl menu = (ModPopupMenuImpl)popupMenu;
        if (menu.getMenuItemList() != null && !menu.getMenuItemList().isEmpty()) {
            ArrayList<DropDownItem> items = new ArrayList<DropDownItem>();
            menu.getMenuItemList().forEach(menuItem -> items.add(this.dropDownItemBuilder((ModPopupMenuImpl.MenuItem)menuItem, blockPos)));
            this.display(items);
        }
    }

    private DropDownItem dropDownItemBuilder(ModPopupMenuImpl.MenuItem menuItem, BlockPos blockPos) {
        DropDownItem dropDownItem;
        if (menuItem.isAutoCloseable()) {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> menuItem.getAction().doAction(blockPos));
        } else {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> menuItem.getSubMenuAction().doAction(blockPos, (Button)b));
            dropDownItem.setOnHover((button, isHovered) -> menuItem.getSubMenuAction().onHoverState(blockPos, button, isHovered));
        }
        return dropDownItem;
    }
}

