/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.concurrent.CompletableFuture;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.DeathWaypointEvent;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.WaypointProperties;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;

public class DeathPointHandler {
    Minecraft mc = Minecraft.getInstance();

    public void handlePlayerDeath() {
        if (JourneymapClient.getInstance().enabled() && this.mc.player != null) {
            this.createDeathpoint();
        }
    }

    private void createDeathpoint() {
        try {
            LocalPlayer player = this.mc.player;
            if (player == null) {
                Journeymap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            WaypointProperties waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
            boolean enabled = waypointProperties.managerEnabled.get() != false && waypointProperties.createDeathpoints.get() != false && JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints();
            boolean cancelled = false;
            int buildMinY = player.getCommandSenderWorld().dimensionType().minY() + 2;
            double playerY = Math.max(Mth.floor((double)player.getY()), buildMinY);
            BlockPos pos = BlockPos.containing((double)player.getX(), (double)playerY, (double)player.getZ());
            if (enabled) {
                ResourceKey dim = Minecraft.getInstance().player.getCommandSenderWorld().dimension();
                DeathWaypointEvent event = new DeathWaypointEvent(pos, dim);
                EventBus.post(event);
                if (!event.isCancelled()) {
                    CompletableFuture.runAsync(() -> {
                        try {
                            Thread.sleep(3000L);
                            WaypointFactoryImpl.createDeathPoint(pos, dim.location().toString());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }, Util.backgroundExecutor());
                } else {
                    cancelled = true;
                }
            }
            Journeymap.getLogger().info(String.format("%s died at %s. Deathpoints enabled: %s. Deathpoint created: %s", player.getName().getString(), pos, enabled, cancelled ? "cancelled" : Boolean.valueOf(true)));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }
}

