/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import de.srendi.advancedperipherals.common.blocks.base.BaseBlock;
import de.srendi.advancedperipherals.common.blocks.base.IInventoryBlock;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBlockEntityBlock
extends BaseBlock
implements EntityBlock {
    private final boolean belongToTickingEntity;

    public BaseBlockEntityBlock(boolean belongToTickingEntity) {
        this(belongToTickingEntity, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(DyeColor.GRAY).strength(1.0f, 5.0f).sound(SoundType.METAL).noOcclusion().requiresCorrectToolForDrops());
    }

    public BaseBlockEntityBlock(boolean belongToTickingEntity, BlockBehaviour.Properties properties) {
        super(properties, (TagKey<Block>)BlockTags.NEEDS_IRON_TOOL);
        this.belongToTickingEntity = belongToTickingEntity;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (levelIn.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = levelIn.getBlockEntity(pos);
        if (tileEntity != null && !(tileEntity instanceof IInventoryBlock)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        MenuProvider namedContainerProvider = this.getMenuProvider(state, levelIn, pos);
        if (namedContainerProvider != null) {
            if (!(player instanceof ServerPlayer)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            serverPlayerEntity.openMenu(namedContainerProvider, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof Container) {
                Container container = (Container)tileEntity;
                Containers.dropContents((Level)worldIn, (BlockPos)pos, (Container)container);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.getBlockEntity(pos) == null) {
            return;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity blockEntity2 = (BaseContainerBlockEntity)blockEntity;
            blockEntity2.name = stack.getHoverName();
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.isClientSide || !this.belongToTickingEntity) {
            return null;
        }
        return (level1, blockPos, blockState, entity) -> {
            if (entity instanceof IPeripheralTileEntity) {
                IPeripheralTileEntity blockEntity = (IPeripheralTileEntity)entity;
                blockEntity.handleTick(level, state, type);
            }
        };
    }

    @Deprecated
    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (!(blockentity instanceof MenuProvider)) {
            return null;
        }
        MenuProvider menuProvider = (MenuProvider)blockentity;
        return menuProvider;
    }

    @Override
    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }
}

