/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemChemicalHandler;
import mekanism.api.chemical.ChemicalStack;
import org.jetbrains.annotations.NotNull;

public class RSChemicalHandler
implements IStorageSystemChemicalHandler {
    @NotNull
    private final Network network;
    private final StorageNetworkComponent component;

    public RSChemicalHandler(@NotNull Network network) {
        this.network = network;
        this.component = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, ChemicalStack resource, @NotNull mekanism.api.Action action) {
        if (resource.isEmpty()) {
            return resource;
        }
        long amountInserted = this.component.insert((ResourceKey)ChemicalResource.ofChemicalStack((ChemicalStack)resource), resource.getAmount(), action == mekanism.api.Action.SIMULATE ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        ChemicalStack remain = resource.copyWithAmount(resource.getAmount() - amountInserted);
        return remain;
    }

    @Override
    public ChemicalStack extractChemical(ChemicalFilter filter, long count, mekanism.api.Action simulate) {
        AdvancedPeripherals.debug("Trying to extract chemical from filter: " + String.valueOf(filter));
        ChemicalResource chemical = RSApi.getChemical(this.network, filter);
        if (chemical == null) {
            return ChemicalStack.EMPTY;
        }
        long amountExtracted = this.component.extract((ResourceKey)chemical, filter.getCount(), simulate == mekanism.api.Action.SIMULATE ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        ChemicalStack extracted = ChemicalUtil.toChemicalStack(chemical.chemical(), amountExtracted);
        AdvancedPeripherals.debug("Extracted chemical: " + String.valueOf(extracted) + " from filter: " + String.valueOf(filter));
        return extracted;
    }
}

