/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.util;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;

public interface OritechEnergyItem
extends EnergyApi.ItemProvider {
    default public long getEnergyCapacity(ItemStack stack) {
        return 10000L;
    }

    default public long getEnergyMaxInput(ItemStack stack) {
        return 500L;
    }

    default public long getEnergyMaxOutput(ItemStack stack) {
        return 0L;
    }

    default public boolean tryUseEnergy(ItemStack stack, long amount, Player player) {
        EnergyApi.EnergyStorage storage;
        RandomSource random = RandomSource.create();
        int unbreakingLevel = this.getUnbreakingLevel(stack);
        if (unbreakingLevel > 0) {
            amount /= (long)(random.nextInt(unbreakingLevel) + 1);
        }
        if ((storage = this.getEnergyStorage(stack)) instanceof SimpleEnergyItemStorage) {
            SimpleEnergyItemStorage itemStorage = (SimpleEnergyItemStorage)storage;
            long extracted = itemStorage.extractIgnoringLimit(amount, false);
            if (extracted > 0L) {
                itemStorage.update();
            }
            return extracted == amount;
        }
        return false;
    }

    private int getUnbreakingLevel(ItemStack stack) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Holder entry : enchantments.keySet()) {
            if (!entry.unwrapKey().isPresent() || !((ResourceKey)entry.unwrapKey().get()).equals(Enchantments.UNBREAKING)) continue;
            return enchantments.getLevel(entry);
        }
        return 0;
    }

    default public long getStoredEnergy(ItemStack stack) {
        return this.getEnergyStorage(stack).getAmount();
    }

    @Override
    default public EnergyApi.EnergyStorage getEnergyStorage(ItemStack stack) {
        return new SimpleEnergyItemStorage(this.getEnergyMaxInput(stack), this.getEnergyMaxOutput(stack), this.getEnergyCapacity(stack), stack);
    }
}

