/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import rearth.oritech.block.blocks.pipes.GenericPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.ItemContent;

public abstract class ExtractablePipeConnectionBlock
extends GenericPipeConnectionBlock {
    public static final int EXTRACT = 2;
    public static final IntegerProperty NORTH = IntegerProperty.create((String)"north", (int)0, (int)2);
    public static final IntegerProperty EAST = IntegerProperty.create((String)"east", (int)0, (int)2);
    public static final IntegerProperty SOUTH = IntegerProperty.create((String)"south", (int)0, (int)2);
    public static final IntegerProperty WEST = IntegerProperty.create((String)"west", (int)0, (int)2);
    public static final IntegerProperty UP = IntegerProperty.create((String)"up", (int)0, (int)2);
    public static final IntegerProperty DOWN = IntegerProperty.create((String)"down", (int)0, (int)2);

    public ExtractablePipeConnectionBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        IntegerProperty property;
        if (player.isHolding(ItemContent.WRENCH)) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Direction interactDir = this.getInteractDirection(state, pos, player);
        if (!this.hasMachineInDirection(interactDir, world, pos, this.apiValidationFunction())) {
            return InteractionResult.PASS;
        }
        Integer connection = (Integer)state.getValue((Property)(property = this.directionToProperty(interactDir)));
        world.setBlock(pos, (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(connection != 2 ? 2 : CONNECTION)), 16, 0);
        world.playSound(null, pos, SoundEvents.BAMBOO_WOOD_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.9f, 1.2f);
        this.invalidateTargetCache(world, pos);
        return InteractionResult.SUCCESS;
    }

    public boolean hasExtractingSide(BlockState state) {
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            IntegerProperty property = this.directionToProperty(direction);
            if ((Integer)state.getValue((Property)property) != 2) continue;
            return true;
        }
        return false;
    }

    protected void invalidateTargetCache(Level world, BlockPos pos) {
        GenericPipeInterfaceEntity.PipeNetworkData data = this.getNetworkData(world);
        Integer network = data.pipeNetworkLinks.getOrDefault(pos, null);
        if (network != null) {
            HashSet<BlockPos> checked = new HashSet<BlockPos>();
            for (Tuple<BlockPos, Direction> pipeInterface : data.pipeNetworkInterfaces.get(network)) {
                BlockPos pipePos = ((BlockPos)pipeInterface.getA()).relative((Direction)pipeInterface.getB());
                if (checked.contains(pipePos)) continue;
                checked.add(pipePos);
                BlockEntity pipeEntity = world.getBlockEntity(pipePos);
                if (!(pipeEntity instanceof ExtractablePipeInterfaceEntity)) continue;
                ((ExtractablePipeInterfaceEntity)pipeEntity).invalidateTargetCache();
            }
        }
    }

    @Override
    public BlockState addConnectionStates(BlockState state, Level world, BlockPos pos, boolean createConnection) {
        state = this.addFluidState(state, pos, world);
        for (Direction direction : Direction.values()) {
            IntegerProperty property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, createConnection);
            if (connection && (Integer)state.getValue((Property)property) == 2) continue;
            state = (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(connection ? CONNECTION : NO_CONNECTION));
        }
        return this.addStraightState(state);
    }

    @Override
    public BlockState addConnectionStates(BlockState state, Level world, BlockPos pos, Direction createDirection) {
        state = this.addFluidState(state, pos, world);
        for (Direction direction : Direction.values()) {
            IntegerProperty property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, direction.equals((Object)createDirection));
            int newValue = connection ? (this.isSideExtractable(state, direction) ? 2 : CONNECTION) : NO_CONNECTION;
            state = (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(newValue));
        }
        return this.addStraightState(state);
    }

    public boolean isExtractable(BlockState state) {
        for (Direction side : Direction.values()) {
            if (!this.isSideExtractable(state, side)) continue;
            return true;
        }
        return false;
    }

    public boolean isSideExtractable(BlockState state, Direction side) {
        return this.directionToPropertyValue(state, side) == 2;
    }

    @Override
    public IntegerProperty getNorthProperty() {
        return NORTH;
    }

    @Override
    public IntegerProperty getEastProperty() {
        return EAST;
    }

    @Override
    public IntegerProperty getSouthProperty() {
        return SOUTH;
    }

    @Override
    public IntegerProperty getWestProperty() {
        return WEST;
    }

    @Override
    public IntegerProperty getUpProperty() {
        return UP;
    }

    @Override
    public IntegerProperty getDownProperty() {
        return DOWN;
    }
}

