/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.networking;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import rearth.oritech.Oritech;
import rearth.oritech.OritechPlatform;
import rearth.oritech.api.networking.AdditionalNetworkingProvider;
import rearth.oritech.api.networking.NetworkedEventHandler;
import rearth.oritech.api.networking.ReflectiveCodecBuilder;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;
import rearth.oritech.api.networking.WorldPacketCodec;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.block.entity.arcane.EnchanterBlockEntity;
import rearth.oritech.block.entity.arcane.EnchantmentCatalystBlockEntity;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.block.entity.pipes.ItemPipeInterfaceEntity;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.armor.JetpackItem;

public class NetworkManager {
    private static final Map<Type, StreamCodec<? extends ByteBuf, ?>> AUTO_CODECS = new HashMap();
    private static final Map<Integer, List<Field>> CACHED_FIELDS = new HashMap<Integer, List<Field>>();
    public static Codec<FluidStack> FLUID_STACK_CODEC;
    public static StreamCodec<RegistryFriendlyByteBuf, FluidStack> FLUID_STACK_STREAM_CODEC;
    public static StreamCodec<RegistryFriendlyByteBuf, BlockState> SIMPLE_BLOCK_STATE_PACKET_CODEC;
    public static StreamCodec<RegistryFriendlyByteBuf, Vector2i> VEC2I_PACKED_CODEC;
    public static StreamCodec<RegistryFriendlyByteBuf, Vec3> VEC3D_PACKET_CODEC;

    public static void sendBlockHandle(BlockEntity blockEntity, CustomPacketPayload message) {
        OritechPlatform.INSTANCE.sendBlockHandle(blockEntity, message);
    }

    public static void sendPlayerHandle(CustomPacketPayload message, ServerPlayer player) {
        OritechPlatform.INSTANCE.sendPlayerHandle(message, player);
    }

    public static void sendToServer(CustomPacketPayload message) {
        OritechPlatform.INSTANCE.sendToServer(message);
    }

    public static <T extends CustomPacketPayload> void registerToClient(CustomPacketPayload.Type<T> id, StreamCodec<RegistryFriendlyByteBuf, T> packetCodec, TriConsumer<T, Level, RegistryAccess> consumer) {
        OritechPlatform.INSTANCE.registerToClient(id, packetCodec, consumer);
    }

    public static <T extends CustomPacketPayload> void registerToServer(CustomPacketPayload.Type<T> id, StreamCodec<RegistryFriendlyByteBuf, T> packetCodec, TriConsumer<T, Player, RegistryAccess> consumer) {
        OritechPlatform.INSTANCE.registerToServer(id, packetCodec, consumer);
    }

    public static void registerDefaultCodecs() {
        NetworkManager.registerCodec(ByteBufCodecs.INT, new Type[]{Integer.class, Integer.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.VAR_LONG, new Type[]{Long.class, Long.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.FLOAT, new Type[]{Float.class, Float.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.BOOL, new Type[]{Boolean.class, Boolean.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.DOUBLE, new Type[]{Double.class, Double.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.BYTE, new Type[]{Byte.class, Byte.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.SHORT, new Type[]{Short.class, Short.TYPE});
        NetworkManager.registerCodec(ByteBufCodecs.STRING_UTF8, new Type[]{String.class});
        NetworkManager.registerCodec(ResourceLocation.STREAM_CODEC, new Type[]{ResourceLocation.class});
        NetworkManager.registerCodec(BlockPos.STREAM_CODEC, new Type[]{BlockPos.class});
        NetworkManager.registerCodec(ItemStack.OPTIONAL_STREAM_CODEC, new Type[]{ItemStack.class});
        NetworkManager.registerCodec(VEC2I_PACKED_CODEC, new Type[]{Vector2i.class});
        NetworkManager.registerCodec(VEC3D_PACKET_CODEC, new Type[]{Vec3.class});
        NetworkManager.registerCodec(SIMPLE_BLOCK_STATE_PACKET_CODEC, new Type[]{BlockState.class});
        NetworkManager.registerCodec(FLUID_STACK_STREAM_CODEC, new Type[]{FluidStack.class});
        NetworkManager.registerCodec(ItemFilterBlockEntity.FilterData.PACKET_CODEC, new Type[]{ItemFilterBlockEntity.FilterData.class});
        NetworkManager.registerCodec(OritechRecipeType.PACKET_CODEC, new Type[]{OritechRecipe.class});
        NetworkManager.registerCodec(LaserArmBlockEntity.LASER_TARGET_PACKET_CODEC, new Type[]{LivingEntity.class});
        NetworkManager.registerCodec(AugmentApplicationEntity.ResearchState.PACKET_CODEC, new Type[]{AugmentApplicationEntity.ResearchState.class});
    }

    public static <T> void registerCodec(StreamCodec<? extends ByteBuf, T> codec, Type ... classes) {
        for (Type clazz : classes) {
            AUTO_CODECS.put(clazz, codec);
        }
    }

    public static void init() {
        NetworkManager.registerDefaultCodecs();
        NetworkManager.registerToServer(ItemFilterBlockEntity.ItemFilterPayload.FILTER_PACKET_ID, ItemFilterBlockEntity.ItemFilterPayload.PACKET_CODEC, ItemFilterBlockEntity::handleClientUpdate);
        NetworkManager.registerToServer(EnchanterBlockEntity.SelectEnchantingPacket.PACKET_ID, NetworkManager.getAutoCodec(EnchanterBlockEntity.SelectEnchantingPacket.class), EnchanterBlockEntity::receiveEnchantmentSelection);
        NetworkManager.registerToServer(RedstoneAddonBlockEntity.RedstoneAddonServerUpdate.PACKET_ID, NetworkManager.getAutoCodec(RedstoneAddonBlockEntity.RedstoneAddonServerUpdate.class), RedstoneAddonBlockEntity::receiveOnServer);
        NetworkManager.registerToServer(PortableLaserItem.LaserPlayerUsePacket.PACKET_ID, NetworkManager.getAutoCodec(PortableLaserItem.LaserPlayerUsePacket.class), PortableLaserItem::receiveUsePacket);
        NetworkManager.registerToServer(MachineBlockEntity.InventoryInputModeSelectorPacket.PACKET_ID, NetworkManager.getAutoCodec(MachineBlockEntity.InventoryInputModeSelectorPacket.class), MachineBlockEntity::receiveCycleModePacket);
        NetworkManager.registerToServer(InventoryProxyAddonBlockEntity.InventoryProxySlotSelectorPacket.PACKET_ID, NetworkManager.getAutoCodec(InventoryProxyAddonBlockEntity.InventoryProxySlotSelectorPacket.class), InventoryProxyAddonBlockEntity::receiveSlotSelection);
        NetworkManager.registerToServer(JetpackItem.JetpackUsageUpdatePacket.PACKET_ID, NetworkManager.getAutoCodec(JetpackItem.JetpackUsageUpdatePacket.class), JetpackItem::receiveUsagePacket);
        NetworkManager.registerToServer(PlayerAugments.AugmentInstallTriggerPacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.AugmentInstallTriggerPacket.class), PlayerAugments::receiveInstallTrigger);
        NetworkManager.registerToServer(PlayerAugments.LoadPlayerAugmentsToMachinePacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.LoadPlayerAugmentsToMachinePacket.class), PlayerAugments::receivePlayerLoadMachine);
        NetworkManager.registerToServer(PlayerAugments.OpenAugmentScreenPacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.OpenAugmentScreenPacket.class), PlayerAugments::receiveOpenAugmentScreen);
        NetworkManager.registerToServer(PlayerAugments.AugmentPlayerTogglePacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.AugmentPlayerTogglePacket.class), PlayerAugments::receiveToggleAugment);
        NetworkManager.registerToServer(ShrinkerBlockEntity.ShrinkerPlayerUsePacket.PACKET_ID, NetworkManager.getAutoCodec(ShrinkerBlockEntity.ShrinkerPlayerUsePacket.class), ShrinkerBlockEntity::onPlayerUse);
        NetworkManager.registerToClient(MessagePayload.GENERIC_PACKET_ID, MessagePayload.PACKET_CODEC, NetworkManager::receiveMessage);
        NetworkManager.registerToClient(ItemPipeInterfaceEntity.RenderStackData.PIPE_ITEMS_ID, NetworkManager.getAutoCodec(ItemPipeInterfaceEntity.RenderStackData.class), ItemPipeInterfaceEntity::receiveVisualItemsPacket);
        NetworkManager.registerToClient(EnchantmentCatalystBlockEntity.CatalystSyncPacket.PACKET_ID, NetworkManager.getAutoCodec(EnchantmentCatalystBlockEntity.CatalystSyncPacket.class), EnchantmentCatalystBlockEntity::receiveUpdatePacket);
        NetworkManager.registerToClient(SpawnerControllerBlockEntity.SpawnerSyncPacket.PACKET_ID, NetworkManager.getAutoCodec(SpawnerControllerBlockEntity.SpawnerSyncPacket.class), SpawnerControllerBlockEntity::receiveUpdatePacket);
        NetworkManager.registerToClient(RedstoneAddonBlockEntity.RedstoneAddonClientUpdate.PACKET_ID, NetworkManager.getAutoCodec(RedstoneAddonBlockEntity.RedstoneAddonClientUpdate.class), RedstoneAddonBlockEntity::receiveOnClient);
        NetworkManager.registerToClient(AcceleratorControllerBlockEntity.ParticleRenderTrail.PACKET_ID, NetworkManager.getAutoCodec(AcceleratorControllerBlockEntity.ParticleRenderTrail.class), AcceleratorControllerBlockEntity::receiveTrail);
        NetworkManager.registerToClient(AcceleratorControllerBlockEntity.LastEventPacket.PACKET_ID, NetworkManager.getAutoCodec(AcceleratorControllerBlockEntity.LastEventPacket.class), AcceleratorControllerBlockEntity::receiveEvent);
    }

    public static void receiveMessage(MessagePayload message, Level world, RegistryAccess registryAccess) {
        RegistryFriendlyByteBuf receivedBuf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message.message), registryAccess);
        BlockEntity receiverEntity = world.getBlockEntity(message.pos);
        BlockEntityType receiverType = (BlockEntityType)registryAccess.registryOrThrow(Registries.BLOCK_ENTITY_TYPE).get(message.targetEntityType);
        if (receiverEntity != null && receiverType != null && receiverType.equals(receiverEntity.getType())) {
            NetworkManager.decodeFields(receiverEntity, message.syncType, (ByteBuf)receivedBuf, world);
            if (receiverEntity instanceof NetworkedEventHandler) {
                NetworkedEventHandler networkedBlock = (NetworkedEventHandler)receiverEntity;
                networkedBlock.onNetworkUpdated();
            }
        } else {
            Oritech.LOGGER.debug("Unable to start decoding for block entity type {} at {}. Target Mismatch!", (Object)receiverType, (Object)message.pos);
        }
    }

    public static int encodeFields(Object target, SyncType type, ByteBuf byteBuf, @Nullable Level world) {
        List<Field> fields = NetworkManager.getCachedFields(target, type);
        int encodedCount = 0;
        for (Field field : fields) {
            try {
                if (UpdatableField.class.isAssignableFrom(field.getType())) {
                    Object codec;
                    UpdatableField fieldInstance = (UpdatableField)field.get(target);
                    boolean deltaOnly = fieldInstance.useDeltaOnly(type);
                    UpdatableField dataToSend = deltaOnly ? fieldInstance.getDeltaData() : fieldInstance;
                    Object object = codec = deltaOnly ? fieldInstance.getDeltaCodec() : fieldInstance.getFullCodec();
                    if (codec instanceof WorldPacketCodec) {
                        WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                        worldPacketCodec.encode(byteBuf, dataToSend, world);
                    } else {
                        codec.encode((Object)byteBuf, (Object)dataToSend);
                    }
                } else {
                    StreamCodec codec = NetworkManager.getAutoCodec(field);
                    Object value = field.get(target);
                    if (codec instanceof WorldPacketCodec) {
                        WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                        worldPacketCodec.encode(byteBuf, value, world);
                    } else {
                        codec.encode((Object)byteBuf, value);
                    }
                }
                ++encodedCount;
            }
            catch (Exception ex) {
                Oritech.LOGGER.warn("failed to encode field: {}", (Object)field.getName(), (Object)ex);
            }
        }
        return encodedCount;
    }

    public static void decodeFields(Object target, SyncType type, ByteBuf byteBuf, Level world) {
        List<Field> fields = NetworkManager.getCachedFields(target, type);
        for (Field field : fields) {
            try {
                Object value;
                if (UpdatableField.class.isAssignableFrom(field.getType())) {
                    Object value2;
                    Object codec;
                    UpdatableField fieldInstance = (UpdatableField)field.get(target);
                    boolean deltaOnly = fieldInstance.useDeltaOnly(type);
                    Object object = codec = deltaOnly ? fieldInstance.getDeltaCodec() : fieldInstance.getFullCodec();
                    if (codec instanceof WorldPacketCodec) {
                        WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                        value2 = worldPacketCodec.decode(byteBuf, world);
                    } else {
                        value2 = codec.decode((Object)byteBuf);
                    }
                    if (deltaOnly) {
                        fieldInstance.handleDeltaUpdate(value2);
                        continue;
                    }
                    fieldInstance.handleFullUpdate(value2);
                    continue;
                }
                StreamCodec codec = NetworkManager.getAutoCodec(field);
                if (codec instanceof WorldPacketCodec) {
                    WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                    value = worldPacketCodec.decode(byteBuf, world);
                } else {
                    value = codec.decode((Object)byteBuf);
                }
                field.set(target, value);
            }
            catch (Exception ex) {
                Oritech.LOGGER.warn("failed to decode field: {}", (Object)field.getName(), (Object)ex);
            }
        }
    }

    @NotNull
    private static List<Field> getCachedFields(Object target, SyncType type) {
        int key = target.getClass().hashCode() + type.hashCode();
        return CACHED_FIELDS.computeIfAbsent(key, elem -> NetworkManager.getSyncFields(target, type));
    }

    @NotNull
    private static List<Field> getSyncFields(Object target, SyncType type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(target.getClass().getDeclaredFields()));
        for (Class<?> superClass = target.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        fields.stream().filter(field -> NetworkManager.hasSyncType(field.getAnnotation(SyncField.class), type)).forEachOrdered(field -> {
            field.setAccessible(true);
            filteredFields.add((Field)field);
        });
        if (target instanceof AdditionalNetworkingProvider) {
            AdditionalNetworkingProvider additionalNetworkingProvider = (AdditionalNetworkingProvider)target;
            List<Field> addedFields = additionalNetworkingProvider.additionalSyncedFields(type);
            addedFields.forEach(field -> {
                field.setAccessible(true);
                filteredFields.add((Field)field);
            });
        }
        return filteredFields;
    }

    public static StreamCodec getAutoCodec(Class<?> type) {
        if (!AUTO_CODECS.containsKey(type)) {
            if (type.isRecord()) {
                Oritech.LOGGER.debug("creating reflective codec for: " + String.valueOf(type));
                StreamCodec<RegistryFriendlyByteBuf, ?> computedCodec = ReflectiveCodecBuilder.create(type);
                AUTO_CODECS.put(type, computedCodec);
                return computedCodec;
            }
            if (type.isEnum()) {
                Oritech.LOGGER.debug("creating reflective enum codec for: " + String.valueOf(type));
                StreamCodec<RegistryFriendlyByteBuf, ?> computedCodec = ReflectiveCodecBuilder.createForEnum(type);
                AUTO_CODECS.put(type, computedCodec);
                return computedCodec;
            }
        }
        if (!AUTO_CODECS.containsKey(type)) {
            Oritech.LOGGER.error("No codec defined for: {}", type);
        }
        return AUTO_CODECS.get(type);
    }

    public static StreamCodec getAutoCodec(Field field) {
        Optional<Type> listType = NetworkManager.getListType(field.getGenericType());
        if (listType.isPresent()) {
            StreamCodec listTypeCodec = NetworkManager.getAutoCodec((Class)listType.get());
            return listTypeCodec.apply(ByteBufCodecs.list());
        }
        Optional<Type> setType = NetworkManager.getSetType(field.getGenericType());
        if (setType.isPresent()) {
            StreamCodec setTypeCodec = NetworkManager.getAutoCodec((Class)setType.get());
            return setTypeCodec.apply(NetworkManager.toSet());
        }
        Optional<Tuple<Type, Type>> mapType = NetworkManager.getMapType(field.getGenericType());
        if (mapType.isPresent()) {
            StreamCodec keyCodec = NetworkManager.getAutoCodec((Class)mapType.get().getA());
            StreamCodec valueCodec = NetworkManager.getAutoCodec((Class)mapType.get().getB());
            if (keyCodec == null) {
                Oritech.LOGGER.error("Unable to get codec for map key type: {}", field.getType());
            }
            if (valueCodec == null) {
                Oritech.LOGGER.error("Unable to get codec for map value type: {}", field.getType());
            }
            return ByteBufCodecs.map(HashMap::new, (StreamCodec)keyCodec, (StreamCodec)valueCodec);
        }
        return NetworkManager.getAutoCodec(field.getType());
    }

    public static Optional<Type> getListType(Type type) {
        ParameterizedType pType;
        Class rawType;
        if (type instanceof ParameterizedType && (rawType = (Class)(pType = (ParameterizedType)type).getRawType()) instanceof Class && List.class.isAssignableFrom(rawType)) {
            return Optional.of(pType.getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    public static Optional<Type> getSetType(Type type) {
        ParameterizedType pType;
        Class rawType;
        if (type instanceof ParameterizedType && (rawType = (Class)(pType = (ParameterizedType)type).getRawType()) instanceof Class && Set.class.isAssignableFrom(rawType)) {
            return Optional.of(pType.getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    public static Optional<Tuple<Type, Type>> getMapType(Type type) {
        ParameterizedType pType;
        Class rawType;
        if (type instanceof ParameterizedType && (rawType = (Class)(pType = (ParameterizedType)type).getRawType()) instanceof Class && Map.class.isAssignableFrom(rawType)) {
            Type[] typeArgs = pType.getActualTypeArguments();
            return Optional.of(new Tuple((Object)typeArgs[0], (Object)typeArgs[1]));
        }
        return Optional.empty();
    }

    private static boolean hasSyncType(SyncField annotation, SyncType type) {
        if (annotation == null) {
            return false;
        }
        for (SyncType value : annotation.value()) {
            if (!value.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, Set<V>> toSet() {
        return codec -> ByteBufCodecs.collection(HashSet::new, (StreamCodec)codec);
    }

    public static <K, V> StreamCodec<RegistryFriendlyByteBuf, HashMap<K, V>> createMapCodec(Class<K> keyType, Class<V> valueType) {
        return ByteBufCodecs.map(HashMap::new, (StreamCodec)NetworkManager.getAutoCodec(keyType), (StreamCodec)NetworkManager.getAutoCodec(valueType));
    }

    static {
        SIMPLE_BLOCK_STATE_PACKET_CODEC = new StreamCodec<RegistryFriendlyByteBuf, BlockState>(){

            public BlockState decode(RegistryFriendlyByteBuf buf) {
                return ((Block)BuiltInRegistries.BLOCK.get((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf))).defaultBlockState();
            }

            public void encode(RegistryFriendlyByteBuf buf, BlockState value) {
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)BuiltInRegistries.BLOCK.getKey((Object)value.getBlock()));
            }
        };
        VEC2I_PACKED_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Vector2i::x, (StreamCodec)ByteBufCodecs.INT, Vector2i::y, Vector2i::new);
        VEC3D_PACKET_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Vec3>(){

            public Vec3 decode(RegistryFriendlyByteBuf buf) {
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                return new Vec3(x, y, z);
            }

            public void encode(RegistryFriendlyByteBuf buf, Vec3 value) {
                buf.writeDouble(value.x);
                buf.writeDouble(value.y);
                buf.writeDouble(value.z);
            }
        };
    }

    public record MessagePayload(BlockPos pos, ResourceLocation targetEntityType, SyncType syncType, byte[] message) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<MessagePayload> GENERIC_PACKET_ID = new CustomPacketPayload.Type(Oritech.id("generic"));
        public static final StreamCodec<RegistryFriendlyByteBuf, MessagePayload> PACKET_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessagePayload>(){

            public MessagePayload decode(RegistryFriendlyByteBuf buf) {
                return new MessagePayload((BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf), (SyncType)((Object)SyncType.PACKET_CODEC.decode((Object)buf)), (byte[])ByteBufCodecs.BYTE_ARRAY.decode((Object)buf));
            }

            public void encode(RegistryFriendlyByteBuf buf, MessagePayload value) {
                BlockPos.STREAM_CODEC.encode((Object)buf, (Object)value.pos);
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)value.targetEntityType);
                SyncType.PACKET_CODEC.encode((Object)buf, (Object)value.syncType);
                ByteBufCodecs.BYTE_ARRAY.encode((Object)buf, (Object)value.message);
            }
        };

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return GENERIC_PACKET_ID;
        }
    }
}

