/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.item.containers;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.item.ItemApi;

public class DelegatingInventoryStorage
implements ItemApi.InventoryStorage {
    protected final Supplier<ItemApi.InventoryStorage> backingStorage;
    protected final BooleanSupplier validPredicate;

    public DelegatingInventoryStorage(Supplier<ItemApi.InventoryStorage> backingStorage, @Nullable BooleanSupplier validPredicate) {
        this.backingStorage = backingStorage;
        this.validPredicate = validPredicate == null ? () -> true : validPredicate;
    }

    public DelegatingInventoryStorage(ItemApi.InventoryStorage backingStorage, @Nullable BooleanSupplier validPredicate) {
        this(() -> backingStorage, validPredicate);
    }

    @Override
    public void update() {
        if (this.validPredicate.getAsBoolean()) {
            this.backingStorage.get().update();
        }
    }

    @Override
    public boolean supportsInsertion() {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().supportsInsertion();
        }
        return false;
    }

    @Override
    public int insert(ItemStack inserted, boolean simulate) {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().insert(inserted, simulate);
        }
        return 0;
    }

    @Override
    public int insertToSlot(ItemStack inserted, int slot, boolean simulate) {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().insertToSlot(inserted, slot, simulate);
        }
        return 0;
    }

    @Override
    public boolean supportsExtraction() {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().supportsExtraction();
        }
        return false;
    }

    @Override
    public int extract(ItemStack extracted, boolean simulate) {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().extract(extracted, simulate);
        }
        return 0;
    }

    @Override
    public int extractFromSlot(ItemStack extracted, int slot, boolean simulate) {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().extractFromSlot(extracted, slot, simulate);
        }
        return 0;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.validPredicate.getAsBoolean()) {
            this.backingStorage.get().setStackInSlot(slot, stack);
        }
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getSlotCount() {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().getSlotCount();
        }
        return 0;
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().getSlotLimit(slot);
        }
        return 0;
    }
}

