/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.integration.curios;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import artifacts.equipment.client.EquipmentRenderingHandler;
import artifacts.item.WearableArtifactItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosRenderingHandler
implements EquipmentRenderingHandler {
    @Override
    public void registerArtifactRenderer(Item item, Supplier<ArtifactRenderer> rendererSupplier) {
        CuriosRendererRegistry.register((Item)item, () -> new ArtifactCurioRenderer((ArtifactRenderer)rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(Item item) {
        Object t;
        Optional renderer = CuriosRendererRegistry.getRenderer((Item)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactCurioRenderer) {
            ArtifactCurioRenderer artifactTrinketRenderer = (ArtifactCurioRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    @Override
    public void renderArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side) {
        InteractionHand hand = side == player.getMainArm() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
            if (stacksHandler != null) {
                int slot;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                int n = slot = hand == InteractionHand.MAIN_HAND ? 0 : 1;
                while (slot < stacks.getSlots()) {
                    GloveArtifactRenderer renderer;
                    ItemStack stack = cosmeticStacks.getStackInSlot(slot);
                    if (stack.isEmpty() && ((Boolean)stacksHandler.getRenders().get(slot)).booleanValue()) {
                        stack = stacks.getStackInSlot(slot);
                    }
                    if (stack.getItem() instanceof WearableArtifactItem && (renderer = GloveArtifactRenderer.getGloveRenderer(stack)) != null) {
                        renderer.renderFirstPersonArm(matrixStack, buffer, light, player, side, stack.hasFoil());
                    }
                    slot += 2;
                }
            }
        }));
    }

    public record ArtifactCurioRenderer(ArtifactRenderer renderer) implements ICurioRenderer
    {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.renderer.renderVisible(stack, slotContext.entity(), slotContext.index(), poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

