/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.renderer;

import artifacts.client.item.model.BeltModel;
import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.client.item.renderer.BeltArtifactRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class WarpDriveRenderer
extends BeltArtifactRenderer {
    private final List<ResourceLocation> overlayTextures;
    private final Random random = new Random();

    public WarpDriveRenderer(String name, BeltModel model) {
        super("%s/%s".formatted(name, name), model);
        this.overlayTextures = new ArrayList<ResourceLocation>();
        for (int i = 0; i < 4; ++i) {
            this.overlayTextures.add(ArtifactRenderer.getTexturePath(name, "%s_overlay%s".formatted(name, i)));
        }
    }

    @Override
    public void render(ItemStack stack, LivingEntity entity, int slotIndex, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        super.render(stack, entity, slotIndex, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        int interval = 10;
        this.random.setSeed(entity.tickCount);
        if (this.random.nextInt(interval) % interval == 0) {
            RenderType renderType = this.getModel().renderType(this.overlayTextures.get(this.random.nextInt(this.overlayTextures.size())));
            VertexConsumer builder = ItemRenderer.getFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)false, (boolean)false);
            this.getModel().renderToBuffer(poseStack, builder, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY, -1);
        }
    }
}

