/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.taxonomy.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.lucene.ars_nouveau.document.Document;
import org.apache.lucene.ars_nouveau.facet.taxonomy.FacetLabel;
import org.apache.lucene.ars_nouveau.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.ars_nouveau.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.ars_nouveau.index.DirectoryReader;
import org.apache.lucene.ars_nouveau.index.LeafReader;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.store.Directory;
import org.apache.lucene.ars_nouveau.util.IOUtils;

public class ReindexingEnrichedDirectoryTaxonomyWriter
extends DirectoryTaxonomyWriter {
    private BiConsumer<FacetLabel, Document> ordinalDataAppender;

    public ReindexingEnrichedDirectoryTaxonomyWriter(Directory d, BiConsumer<FacetLabel, Document> ordinalDataAppender) throws IOException {
        super(d);
        this.ordinalDataAppender = ordinalDataAppender;
    }

    @Override
    protected void enrichOrdinalDocument(Document d, FacetLabel categoryPath) {
        if (this.ordinalDataAppender != null) {
            this.ordinalDataAppender.accept(categoryPath, d);
        }
    }

    private List<FacetLabel> recordPathsInOrder(Directory d) throws IOException {
        ArrayList<FacetLabel> paths = new ArrayList<FacetLabel>();
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(d);
        DirectoryReader taxoIndexReader = taxoReader.getInternalIndexReader();
        for (LeafReaderContext ctx : taxoIndexReader.leaves()) {
            FacetLabel[] labels;
            LeafReader leafReader = ctx.reader();
            int[] ordinals = new int[leafReader.maxDoc()];
            for (int i = 0; i < ordinals.length; ++i) {
                ordinals[i] = ctx.docBase + i;
            }
            for (FacetLabel label : labels = taxoReader.getBulkPath(ordinals)) {
                paths.add(label);
            }
        }
        IOUtils.close(taxoReader);
        return paths;
    }

    public synchronized void reindexWithNewOrdinalData(BiConsumer<FacetLabel, Document> ordinalDataAppender) throws IOException {
        this.ensureOpen();
        this.ordinalDataAppender = ordinalDataAppender;
        Directory d = this.getDirectory();
        List<FacetLabel> ordinalToPath = this.recordPathsInOrder(d);
        this.deleteAll();
        for (FacetLabel categoryPath : ordinalToPath) {
            this.addCategory(categoryPath);
        }
        this.commit();
    }
}

