/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createliquidfuel.core;

import com.forsteri.createliquidfuel.mixin.BlazeBurnerAccessor;
import com.forsteri.createliquidfuel.util.Triplet;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BurnerStomachHandler {
    public static Map<Fluid, Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>> LIQUID_BURNER_FUEL_MAP = new HashMap<Fluid, Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>>();

    public static void tick(SmartBlockEntity entity) {
        if (!(entity instanceof BlazeBurnerAccessor)) {
            return;
        }
        BlazeBurnerAccessor burnerAccessor = (BlazeBurnerAccessor)entity;
        SmartFluidTank stomach = (SmartFluidTank)entity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, entity.getBlockPos(), (Object)Direction.DOWN);
        if (stomach == null) {
            return;
        }
        if (stomach.getFluid().getAmount() <= 0) {
            return;
        }
        Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>> propertyPair = LIQUID_BURNER_FUEL_MAP.get(stomach.getFluid().getFluid());
        if (propertyPair == null) {
            return;
        }
        Triplet burnerProperty = (Triplet)propertyPair.getSecond();
        if (burnerProperty == null) {
            return;
        }
        boolean fluidSuperHeats = (Boolean)burnerProperty.getSecond();
        int mbConsuming = (Integer)burnerProperty.getThird();
        if (stomach.getFluid().getAmount() < mbConsuming) {
            stomach.getFluid().setAmount(0);
            return;
        }
        if (fluidSuperHeats) {
            burnerAccessor.createliquidfuel$invokeSetBlockHeat(BlazeBurnerBlock.HeatLevel.SEETHING);
        } else {
            burnerAccessor.createliquidfuel$invokeSetBlockHeat(BlazeBurnerBlock.HeatLevel.FADING);
        }
        int newBurnTime = burnerAccessor.createliquidfuel$getRemainingBurnTime() + (Integer)burnerProperty.getFirst();
        if (newBurnTime > 10000) {
            return;
        }
        burnerAccessor.createliquidfuel$setRemainingBurnTime(newBurnTime);
        stomach.getFluid().shrink(mbConsuming);
    }

    public static void tryUpdateFuel(@NotNull SmartBlockEntity entity, ItemStack itemStack, boolean forceOverflow, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        SmartFluidTank stomach = (SmartFluidTank)entity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, entity.getBlockPos(), (Object)Direction.DOWN);
        if (stomach == null) {
            return;
        }
        if (itemStack.getCapability(Capabilities.FluidHandler.ITEM) == null) {
            return;
        }
        IFluidHandler handler = (IFluidHandler)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (!stomach.getFluid().isEmpty() && handler.getFluidInTank(0).getFluid() != stomach.getFluid().getFluid()) {
            return;
        }
        if (handler.getTanks() != 1) {
            return;
        }
        FluidStack fluidStack = handler.getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!LIQUID_BURNER_FUEL_MAP.containsKey(fluidStack.getFluid())) {
            return;
        }
        if (stomach.getFluid().getAmount() + fluidStack.getAmount() > stomach.getCapacity() && !forceOverflow) {
            return;
        }
        if (!simulate) {
            if (stomach.getFluid().isEmpty()) {
                stomach.setFluid(fluidStack.copy());
            } else {
                stomach.getFluid().grow(fluidStack.getAmount());
            }
        }
        cir.setReturnValue((Object)true);
    }
}

