/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.registrars.Registrar;

@SimplyRegister
public record PanelDataComponent(long energy, List<ItemStack> upgrades, List<ItemStack> chargeable) {
    public static final PanelDataComponent EMPTY = new PanelDataComponent(0L, List.of(), List.of());
    public static final Codec<PanelDataComponent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("Energy").forGetter(PanelDataComponent::energy), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("Upgrades").forGetter(PanelDataComponent::upgrades), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("Chargeable").forGetter(PanelDataComponent::chargeable)).apply((Applicative)inst, PanelDataComponent::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> STACK_LIST_ST_CODEC = StreamCodec.of((buf, items) -> {
        buf.writeVarInt(items.size());
        for (ItemStack it : items) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)it);
        }
    }, buf -> {
        NonNullList items = NonNullList.withSize((int)buf.readVarInt(), (Object)ItemStack.EMPTY);
        items.replaceAll(ignore -> (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(buf));
        return List.copyOf(items);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, PanelDataComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, PanelDataComponent::energy, STACK_LIST_ST_CODEC, PanelDataComponent::upgrades, STACK_LIST_ST_CODEC, PanelDataComponent::chargeable, PanelDataComponent::new);
    @RegistryName(value="solar_panel")
    public static final Registrar<DataComponentType<PanelDataComponent>> TYPE = Registrar.dataComponentType((DataComponentType.Builder)DataComponentType.builder().persistent(CODEC).networkSynchronized(STREAM_CODEC).cacheEncoding());

    public boolean isEmpty() {
        return this == EMPTY || this.energy == 0L && this.upgrades.stream().allMatch(ItemStack::isEmpty) && this.chargeable.stream().allMatch(ItemStack::isEmpty);
    }
}

