/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.inventory.container.modular.ModularSlot;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.IdentityProvider;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.inventory.ModularMenuCommon;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModularItemMenu
extends ModularGuiContainerMenu
implements ModuleHostContainer,
ModularMenuCommon {
    public static final Logger LOGGER = LogManager.getLogger();
    private int gridWidth;
    private int gridHeight;
    private UUID hostIdentity;
    private PlayerSlot slot;
    public ItemStack hostStack;
    private ModuleGrid moduleGrid;
    private ModuleHost fallbackHost;
    private Player player;
    public final SlotGroup main = this.createSlotGroup(0, new int[0]);
    public final SlotGroup hotBar = this.createSlotGroup(0, new int[0]);
    public final SlotGroup armor = this.createSlotGroup(0, new int[0]);
    public final SlotGroup offhand = this.createSlotGroup(0, new int[0]);
    public final SlotGroup curios = this.createSlotGroup(0, new int[0]);

    public ModularItemMenu(int windowId, Inventory inv, FriendlyByteBuf extraData) {
        this(windowId, inv, PlayerSlot.fromBuff((ByteBuf)extraData));
    }

    public ModularItemMenu(int windowId, Inventory inv, PlayerSlot itemSlot) {
        super((MenuType)DEContent.MENU_MODULAR_ITEM.get(), windowId, inv);
        this.player = inv.player;
        this.slot = itemSlot;
        this.moduleGrid = new ModuleGrid(this, inv);
        this.hotBar.addPlayerBar(inv);
        this.main.addPlayerMain(inv);
        this.armor.addPlayerArmor(inv);
        this.offhand.addPlayerOffhand(inv);
        EquipmentManager.getEquipmentInventory((LivingEntity)inv.player).ifPresent(handler -> this.curios.addSlots(handler.getSlots(), 0, i -> new ModularSlot((IItemHandler)handler, i.intValue())));
        IdentityProvider.resolveDuplicateIdentities(this.getInventoryStacks(), (HolderLookup.Provider)this.player.registryAccess());
        this.hostStack = this.slot.getStackInSlot(inv.player);
        if (this.hostStack.isEmpty()) {
            return;
        }
        this.fallbackHost = DECapabilities.getHost(this.hostStack);
        if (this.fallbackHost == null) {
            return;
        }
        this.gridWidth = this.fallbackHost.getGridWidth();
        this.gridHeight = this.fallbackHost.getGridHeight();
        this.hostIdentity = this.fallbackHost.getIdentity();
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public List<Slot> getSlots() {
        return this.slots;
    }

    private static Stream<ItemStack> getPlayerInventory(Inventory player) {
        return Streams.concat((Stream[])new Stream[]{player.items.stream(), player.armor.stream(), player.offhand.stream()}).filter(e -> !e.isEmpty());
    }

    public static void tryOpenGui(ServerPlayer sender) {
        ItemStack stack = sender.getMainHandItem();
        if (!stack.isEmpty() && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            PlayerSlot slot = new PlayerSlot((Player)sender, InteractionHand.MAIN_HAND);
            sender.openMenu((MenuProvider)new Provider(stack, slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        PlayerSlot slot = PlayerSlot.findStackActiveFirst((Inventory)sender.getInventory(), e -> e.getCapability(DECapabilities.Host.ITEM) != null);
        if (slot != null) {
            sender.openMenu((MenuProvider)new Provider(slot.getStackInSlot((Player)sender), slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        sender.sendSystemMessage((Component)Component.translatable((String)"modular_item.draconicevolution.error.no_modular_items").withStyle(ChatFormatting.RED));
    }

    @Override
    public ModuleHost getModuleHost() {
        ModuleHost host = DECapabilities.getHost(this.slot.getStackInSlot(this.player));
        if (host == null) {
            LOGGER.error("Module host is null! Something is probably broken, or about to break!, Slot: {} Stack: {}", (Object)this.slot, (Object)this.slot.getStackInSlot(this.player));
        }
        return host == null || !host.getIdentity().equals(this.hostIdentity) ? this.fallbackHost : (this.fallbackHost = host);
    }

    @Override
    public ModuleContext getModuleContext() {
        return new StackModuleContext(this.hostStack, (LivingEntity)this.player, this.slot.getEquipmentSlot());
    }

    @Override
    public void onGridChange() {
        if (EffectiveSide.get().isServer()) {
            for (int i = 0; i < this.slots.size(); ++i) {
                ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
                ItemStack itemstack1 = (ItemStack)this.lastSlots.get(i);
                if (ItemStack.matches((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                itemstack1 = itemstack.copy();
                this.lastSlots.set(i, (Object)itemstack1);
                for (ContainerListener icontainerlistener : this.containerListeners) {
                    icontainerlistener.slotChanged((AbstractContainerMenu)this, i, itemstack1);
                }
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        if (this.hostIdentity == null || this.hostStack.isEmpty() || this.hostStack != this.slot.getStackInSlot(this.player)) {
            return false;
        }
        ModuleHost host = DECapabilities.getHost(this.slot.getStackInSlot(this.player));
        return host != null && host.getIdentity().equals(this.hostIdentity);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        try (ModuleHost host = this.getModuleHost();){
            if (this.quickMoveModule(host, player, this.getSlot(i))) {
                ItemStack itemStack = ItemStack.EMPTY;
                return itemStack;
            }
        }
        return super.quickMoveStack(player, i);
    }

    @Override
    public ModuleGrid getGrid() {
        return this.moduleGrid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        ItemStack stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.isEmpty() && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            this.hostStack = stack;
        }
    }

    public void initializeContents(int stateId, List<ItemStack> stacks, ItemStack carried) {
        super.initializeContents(stateId, stacks, carried);
        ItemStack stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.isEmpty() && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            this.hostStack = stack;
        }
    }

    public void setItem(int slotID, int stateId, ItemStack stack) {
        super.setItem(slotID, stateId, stack);
        stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.isEmpty() && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            this.hostStack = stack;
        }
    }

    public void clicked(int slotId, int button, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.slots.size() && (slot = (Slot)this.slots.get(slotId)) != null && !slot.getItem().isEmpty()) {
            if (slot.getItem() == this.hostStack) {
                return;
            }
            if (clickTypeIn == ClickType.PICKUP && button == 0 && player.containerMenu.getCarried().isEmpty() && slot.getItem().getCapability(DECapabilities.Host.ITEM) != null) {
                if (player instanceof ServerPlayer) {
                    PlayerSlot playerSlot = slotId >= 41 ? new PlayerSlot(slotId - 41, PlayerSlot.EnumInvCategory.EQUIPMENT) : (slotId >= 40 ? new PlayerSlot(slotId - 40, PlayerSlot.EnumInvCategory.OFF_HAND) : (slotId >= 36 ? new PlayerSlot(3 - (slotId - 36), PlayerSlot.EnumInvCategory.ARMOR) : new PlayerSlot(slotId, PlayerSlot.EnumInvCategory.MAIN)));
                    player.openMenu((MenuProvider)new Provider(slot.getItem(), playerSlot), arg_0 -> ((PlayerSlot)playerSlot).toBuff(arg_0));
                } else {
                    player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.25f, 1.0f);
                }
                return;
            }
        }
        if (slotId > 40) {
            return;
        }
        super.clicked(slotId, button, clickTypeIn, player);
    }

    public static class Provider
    implements MenuProvider {
        private ItemStack stack;
        private PlayerSlot slot;

        public Provider(ItemStack stack, PlayerSlot slot) {
            this.stack = stack;
            this.slot = slot;
        }

        public Component getDisplayName() {
            return this.stack.getHoverName().plainCopy().append(" ").append((Component)Component.translatable((String)"gui.draconicevolution.modular_item.modules"));
        }

        @Nullable
        public AbstractContainerMenu createMenu(int menuID, Inventory playerInventory, Player playerEntity) {
            return new ModularItemMenu(menuID, playerInventory, this.slot);
        }
    }
}

