/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.equipment;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.lib.IEquipmentManager;
import com.brandon3055.draconicevolution.integration.equipment.CuriosIntegration;
import com.brandon3055.draconicevolution.integration.equipment.IDEEquipment;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class EquipmentManager
implements IEquipmentManager {
    private static boolean curiosLoaded;
    private static EquipmentManager instance;

    public static void initialize(IEventBus modBus) {
        curiosLoaded = ModList.get().isLoaded("curios");
        if (curiosLoaded) {
            instance = new CuriosIntegration();
        }
        BrandonsCore.equipmentManager = instance;
    }

    public static boolean equipModLoaded() {
        return instance != null;
    }

    public static String equipModID() {
        if (curiosLoaded) {
            return "curios";
        }
        return "";
    }

    public static void registerCapability(RegisterCapabilitiesEvent event, Item item) {
        if (instance != null) {
            if (!(item instanceof IDEEquipment)) {
                throw new IllegalStateException("\"Equipment items\" must implement IDEEquipment");
            }
            instance.registerCap(event, item);
        }
    }

    public static Optional<IItemHandlerModifiable> getEquipmentInventory(LivingEntity entity) {
        if (instance != null) {
            return instance.getInventory(entity);
        }
        return Optional.empty();
    }

    public static ItemStack findItem(Item item, LivingEntity entity) {
        if (instance != null) {
            return instance.findMatchingItem(item, entity);
        }
        return ItemStack.EMPTY;
    }

    public static List<ItemStack> findItems(Item item, LivingEntity entity) {
        return EquipmentManager.findItems((ItemStack stack) -> stack.getItem() == item, entity);
    }

    public static ItemStack findItem(Predicate<ItemStack> predicate, LivingEntity entity) {
        if (instance != null) {
            return instance.findMatchingItem(predicate, entity);
        }
        return ItemStack.EMPTY;
    }

    public static List<ItemStack> findItems(Predicate<ItemStack> predicate, LivingEntity entity) {
        Optional optionalHandler;
        if (instance != null && (optionalHandler = instance.getInventory(entity)).isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optionalHandler.orElseThrow(() -> new WTFException("This should not happen"));
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!predicate.test(stack)) continue;
                list.add(stack);
            }
            return ImmutableList.copyOf(list);
        }
        return Collections.emptyList();
    }

    public static List<ItemStack> getAllItems(LivingEntity entity) {
        return EquipmentManager.findItems((ItemStack stack) -> !stack.isEmpty(), entity);
    }

    public static List<ResourceLocation> getIcons(LivingEntity entity) {
        if (instance == null) {
            return Collections.emptyList();
        }
        return instance.getSlotIcons(entity);
    }

    static {
        instance = null;
    }
}

