/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.fluid_pipe.neoforge;

import com.copycatsplus.copycats.content.copycat.fluid_pipe.CopycatFluidPipeBlockEntity;
import com.copycatsplus.copycats.content.copycat.fluid_pipe.CopycatFluidPipeRenderer;
import com.copycatsplus.copycats.content.copycat.fluid_pipe.neoforge.ExpandedFluidRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class CopycatFluidPipeRendererImpl
extends SafeBlockEntityRenderer<CopycatFluidPipeBlockEntity> {
    public CopycatFluidPipeRendererImpl(BlockEntityRendererProvider.Context context) {
    }

    public static void renderSafe(CopycatFluidPipeRenderer renderer, CopycatFluidPipeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (ItemBlockRenderTypes.getRenderLayers((BlockState)be.getMaterial()).contains(RenderType.solid())) {
            return;
        }
        FluidTransportBehaviour pipe = (FluidTransportBehaviour)be.getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            return;
        }
        boolean centerOccupied = false;
        for (Direction side : Iterate.directions) {
            LerpedFloat progress;
            FluidStack fluidStack;
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progress = flow.progress) == null) continue;
            float value = progress.getValue(partialTicks);
            boolean inbound = flow.inbound;
            if (value == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.getOpposite());
                    if (opposite == null) {
                        value -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)be.getLevel(), (BlockPos)be.getBlockPos().relative(side), (BehaviourType)FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        value -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.getOpposite());
                        if (other == null || !other.inbound && !other.complete) {
                            value -= 1.0E-6f;
                        }
                    }
                }
            }
            ExpandedFluidRenderer.renderFluidStream(fluidStack, side, 0.1875f, value, inbound && !centerOccupied ? 0.1875f : -0.1875f, inbound, buffer, ms, light);
            if (!inbound) continue;
            centerOccupied = true;
        }
    }
}

