/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.AttributeStateBoilerValveMode;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing {
    private final Map<Direction, BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> capabilityCaches = new EnumMap<Direction, BlockCapabilityCache<IChemicalHandler, Direction>>(Direction.class);
    private final List<BlockCapability<?, @Nullable Direction>> portCapabilities = List.of(Capabilities.CHEMICAL.block(), Capabilities.FLUID.block());
    private final Predicate<AttributeStateBoilerValveMode.BoilerValveMode> MODE_MATCHES = mode -> mode == this.getMode();

    public TileEntityBoilerValve(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.BOILER_VALVE, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return side -> ((BoilerMultiblockData)this.getMultiblock()).getChemicalTanks(this.getMode());
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> this.getMode() == AttributeStateBoilerValveMode.BoilerValveMode.INPUT ? ((BoilerMultiblockData)this.getMultiblock()).getFluidTanks(side) : Collections.emptyList();
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.FLUID || type == ContainerType.CHEMICAL) {
            return false;
        }
        return super.persists(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addChemicalTargetCapability(List<MultiblockData.AdvancedCapabilityOutputTarget<IChemicalHandler, AttributeStateBoilerValveMode.BoilerValveMode>> outputTargets, Direction side) {
        @Nullable Object cache = this.capabilityCaches.get(side);
        if (cache == null) {
            cache = Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.relative(side), side.getOpposite());
            this.capabilityCaches.put(side, (BlockCapabilityCache<IChemicalHandler, Direction>)cache);
        }
        outputTargets.add(new MultiblockData.AdvancedCapabilityOutputTarget<IChemicalHandler, AttributeStateBoilerValveMode.BoilerValveMode>((BlockCapabilityCache<IChemicalHandler, Direction>)cache, this.MODE_MATCHES));
    }

    @Override
    public int getRedstoneLevel() {
        return ((BoilerMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    @ComputerMethod(methodDescription="Get the current configuration of this valve")
    AttributeStateBoilerValveMode.BoilerValveMode getMode() {
        return (AttributeStateBoilerValveMode.BoilerValveMode)((Object)this.getBlockState().getValue(AttributeStateBoilerValveMode.modeProperty));
    }

    @ComputerMethod(methodDescription="Change the configuration of this valve")
    void setMode(AttributeStateBoilerValveMode.BoilerValveMode mode) {
        if (mode != this.getMode()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(AttributeStateBoilerValveMode.modeProperty, (Comparable)((Object)mode)));
            this.invalidateCapabilitiesAll(this.portCapabilities);
        }
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            AttributeStateBoilerValveMode.BoilerValveMode mode = (AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getNext();
            this.setMode(mode);
            player.displayClientMessage((Component)MekanismLang.BOILER_VALVE_MODE_CHANGE.translateColored(EnumColor.GRAY, mode), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    public FluidStack insertFluid(int tank, @NotNull FluidStack stack, Direction side, @NotNull Action action) {
        return this.handleValves(stack, action, super.insertFluid(tank, stack, side, action));
    }

    @Override
    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, Direction side, @NotNull Action action) {
        return this.handleValves(stack, action, super.insertFluid(stack, side, action));
    }

    private FluidStack handleValves(@NotNull FluidStack stack, @NotNull Action action, @NotNull FluidStack remainder) {
        if (action.execute() && remainder.getAmount() < stack.getAmount()) {
            ((BoilerMultiblockData)this.getMultiblock()).triggerValveTransfer(this);
        }
        return remainder;
    }

    @ComputerMethod(methodDescription="Toggle the current valve configuration to the next option in the list")
    void incrementMode() {
        this.setMode((AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getNext());
    }

    @ComputerMethod(methodDescription="Toggle the current valve configuration to the previous option in the list")
    void decrementMode() {
        this.setMode((AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getPrevious());
    }
}

