/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.chemical.VariableCapacityChemicalTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.HybridInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankMultiblockData
extends MultiblockData
implements IValveHandler {
    @ContainerSync
    public final MergedTank mergedTank;
    @ContainerSync
    @SyntheticComputerMethod(getter="getContainerEditMode")
    public IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    HybridInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    HybridInventorySlot outputSlot;
    private int tankCapacity;
    private long chemicalTankCapacity;
    public float prevScale;

    public TankMultiblockData(TileEntityDynamicTank tile) {
        super(tile);
        IContentsListener saveAndComparator = this.createSaveAndComparator();
        this.mergedTank = MergedTank.create(VariableCapacityFluidTank.create(this, this::getTankCapacity, ConstantPredicates.alwaysTrue(), saveAndComparator), VariableCapacityChemicalTank.create(this, this::getChemicalTankCapacity, ConstantPredicates.alwaysTrue(), saveAndComparator));
        this.fluidTanks.add(this.mergedTank.getFluidTank());
        this.chemicalTanks.add(this.mergedTank.getChemicalTank());
        this.inventorySlots.addAll(this.createBaseInventorySlots());
    }

    private List<IInventorySlot> createBaseInventorySlots() {
        ArrayList<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
        this.inputSlot = HybridInventorySlot.inputOrDrain(this.mergedTank, this, 146, 21);
        inventorySlots.add(this.inputSlot);
        this.outputSlot = HybridInventorySlot.outputOrFill(this.mergedTank, this, 146, 51);
        inventorySlots.add(this.outputSlot);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return inventorySlots;
    }

    @Override
    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        MergedTank.CurrentType type = this.mergedTank.getCurrentType();
        if (type == MergedTank.CurrentType.EMPTY) {
            this.inputSlot.handleTank(this.outputSlot, this.editMode);
            this.inputSlot.drainChemicalTank();
            this.outputSlot.fillChemicalTank();
        } else if (type == MergedTank.CurrentType.FLUID) {
            this.inputSlot.handleTank(this.outputSlot, this.editMode);
        } else {
            this.inputSlot.drainChemicalTank();
            this.outputSlot.fillChemicalTank();
        }
        float scale = this.getScale();
        if (MekanismUtils.scaleChanged(scale, this.prevScale)) {
            this.prevScale = scale;
            needsPacket = true;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.readUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
        this.mergedTank.readFromUpdateTag(provider, tag);
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeUpdateTag(tag, provider);
        tag.putFloat("scale", this.prevScale);
        this.mergedTank.addToUpdateTag(provider, tag);
        this.writeValves(tag);
    }

    private float getScale() {
        return switch (this.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> MekanismUtils.getScale(this.prevScale, this.getFluidTank());
            case MergedTank.CurrentType.CHEMICAL -> MekanismUtils.getScale(this.prevScale, this.getChemicalTank());
            default -> MekanismUtils.getScale(this.prevScale, 0L, this.getChemicalTankCapacity(), true);
        };
    }

    @ComputerMethod
    public int getTankCapacity() {
        return this.tankCapacity;
    }

    @ComputerMethod
    public long getChemicalTankCapacity() {
        return this.chemicalTankCapacity;
    }

    @Override
    public void setVolume(int volume) {
        if (this.getVolume() != volume) {
            super.setVolume(volume);
            this.tankCapacity = volume * MekanismConfig.general.dynamicTankFluidPerTank.get();
            this.chemicalTankCapacity = (long)volume * MekanismConfig.general.dynamicTankChemicalPerTank.get();
        }
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        long capacity = this.mergedTank.getCurrentType() == MergedTank.CurrentType.FLUID ? (long)this.getTankCapacity() : this.getChemicalTankCapacity();
        return MekanismUtils.redstoneLevelFromContents(this.getStoredAmount(), capacity);
    }

    private long getStoredAmount() {
        return switch (this.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> this.getFluidTank().getFluidAmount();
            case MergedTank.CurrentType.CHEMICAL -> this.getChemicalTank().getStored();
            default -> 0L;
        };
    }

    public IExtendedFluidTank getFluidTank() {
        return this.mergedTank.getFluidTank();
    }

    public IChemicalTank getChemicalTank() {
        return this.mergedTank.getChemicalTank();
    }

    public boolean isEmpty() {
        return this.mergedTank.getCurrentType() == MergedTank.CurrentType.EMPTY;
    }

    @ComputerMethod
    public void setContainerEditMode(IFluidContainerManager.ContainerEditMode mode) {
        if (this.editMode != mode) {
            this.editMode = mode;
            this.markDirty();
        }
    }

    @ComputerMethod
    void incrementContainerEditMode() {
        this.setContainerEditMode((IFluidContainerManager.ContainerEditMode)this.editMode.getNext());
    }

    @ComputerMethod
    void decrementContainerEditMode() {
        this.setContainerEditMode((IFluidContainerManager.ContainerEditMode)this.editMode.getPrevious());
    }

    @ComputerMethod
    Either<ChemicalStack, FluidStack> getStored() {
        return switch (this.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> Either.right((Object)this.getFluidTank().getFluid());
            case MergedTank.CurrentType.CHEMICAL -> Either.left((Object)this.getChemicalTank().getStack());
            default -> Either.right((Object)FluidStack.EMPTY);
        };
    }

    @ComputerMethod
    double getFilledPercentage() {
        long capacity = this.mergedTank.getCurrentType() == MergedTank.CurrentType.FLUID ? (long)this.getTankCapacity() : this.getChemicalTankCapacity();
        return (double)this.getStoredAmount() / (double)capacity;
    }
}

