/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.RelativeSide;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.chemical.IChemicalTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.content.network.distribution.FluidHandlerTarget;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EntangloporterInventorySlot;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryFrequency
extends Frequency
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IChemicalTracker {
    public static final Codec<InventoryFrequency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(Frequency::getName), (App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(freq -> Optional.ofNullable(freq.getOwner())), (App)SecurityMode.CODEC.fieldOf("security_mode").forGetter(Frequency::getSecurity), (App)SerializerHelper.POSITIVE_LONG_CODEC_LEGACY.fieldOf("energy").forGetter(freq -> freq.storedEnergy.getEnergy()), (App)SerializerHelper.LENIENT_OPTIONAL_FLUID_CODEC.fieldOf("fluid").forGetter(freq -> freq.storedFluid.getFluid()), (App)ChemicalStack.LENIENT_OPTIONAL_CODEC.optionalFieldOf("chemical").forGetter(freq -> Optional.of(freq.storedChemical.getStack())), (App)SerializerHelper.LENIENT_OPTIONAL_STACK_CODEC.fieldOf("item").forGetter(freq -> freq.storedItem.getStack()), (App)Codec.DOUBLE.fieldOf("heat").forGetter(freq -> freq.storedHeat.getHeat()), (App)Codec.DOUBLE.fieldOf("heat_capacity").forGetter(freq -> freq.storedHeat.getHeatCapacity()), (App)ChemicalStack.LENIENT_OPTIONAL_CODEC.optionalFieldOf("gas").forGetter(freq -> Optional.empty()), (App)ChemicalStack.LENIENT_OPTIONAL_CODEC.optionalFieldOf("infuse_type").forGetter(freq -> Optional.empty()), (App)ChemicalStack.LENIENT_OPTIONAL_CODEC.optionalFieldOf("pigment").forGetter(freq -> Optional.empty()), (App)ChemicalStack.LENIENT_OPTIONAL_CODEC.optionalFieldOf("slurry").forGetter(freq -> Optional.empty())).apply((Applicative)instance, (name, owner, securityMode, energy, fluid, chemical, item, heat, heatCapacity, legacyGas, legacyInfuse, legacyPigment, legacySlurry) -> {
        InventoryFrequency frequency = new InventoryFrequency((String)name, owner.orElse(null), (SecurityMode)securityMode);
        frequency.storedEnergy.setEnergy((long)energy);
        frequency.storedFluid.setStackUnchecked((FluidStack)fluid);
        if (chemical.isPresent()) {
            frequency.storedChemical.setStackUnchecked((ChemicalStack)chemical.get());
        } else if (legacyGas.isPresent() && !((ChemicalStack)legacyGas.get()).isEmpty()) {
            frequency.storedChemical.setStackUnchecked((ChemicalStack)legacyGas.get());
        } else if (legacyInfuse.isPresent() && !((ChemicalStack)legacyInfuse.get()).isEmpty()) {
            frequency.storedChemical.setStackUnchecked((ChemicalStack)legacyInfuse.get());
        } else if (legacyPigment.isPresent() && !((ChemicalStack)legacyPigment.get()).isEmpty()) {
            frequency.storedChemical.setStackUnchecked((ChemicalStack)legacyPigment.get());
        } else if (legacySlurry.isPresent() && !((ChemicalStack)legacySlurry.get()).isEmpty()) {
            frequency.storedChemical.setStackUnchecked((ChemicalStack)legacySlurry.get());
        }
        frequency.storedItem.setStackUnchecked((ItemStack)item);
        frequency.storedHeat.setHeat((double)heat);
        frequency.storedHeat.setHeatCapacity((double)heatCapacity, false);
        return frequency;
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryFrequency> STREAM_CODEC = StreamCodec.composite(InventoryFrequency.baseStreamCodec(InventoryFrequency::new), Function.identity(), (StreamCodec)ByteBufCodecs.VAR_LONG, freq -> freq.storedEnergy.getEnergy(), (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, freq -> freq.storedFluid.getFluid(), ChemicalStack.OPTIONAL_STREAM_CODEC, freq -> freq.storedChemical.getStack(), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, freq -> freq.storedItem.getStack(), (StreamCodec)ByteBufCodecs.DOUBLE, freq -> freq.storedHeat.getHeat(), (frequency, energy, fluid, chemical, item, heat) -> {
        frequency.storedEnergy.setEnergy((long)energy);
        frequency.storedFluid.setStack((FluidStack)fluid);
        frequency.storedChemical.setStack((ChemicalStack)chemical);
        frequency.storedItem.setStack((ItemStack)item);
        frequency.storedHeat.setHeat((double)heat);
        return frequency;
    });
    private final Table<ResourceKey<Level>, BlockPos, TileEntityQuantumEntangloporter> activeQEs = Tables.newCustomTable(new IdentityHashMap(), TreeMap::new);
    private long lastEject = -1L;
    private BasicFluidTank storedFluid;
    private IChemicalTank storedChemical;
    private BasicInventorySlot storedItem;
    public IEnergyContainer storedEnergy;
    private BasicHeatCapacitor storedHeat;
    private List<IInventorySlot> inventorySlots;
    private List<IChemicalTank> chemicalTanks;
    private List<IExtendedFluidTank> fluidTanks;
    private List<IEnergyContainer> energyContainers;
    private List<IHeatCapacitor> heatCapacitors;

    public InventoryFrequency(String n, @Nullable UUID uuid, SecurityMode securityMode) {
        super(FrequencyType.INVENTORY, n, uuid, securityMode);
        this.presetVariables();
    }

    private InventoryFrequency(String name, @Nullable UUID owner, String ownerName, SecurityMode securityMode) {
        super(FrequencyType.INVENTORY, name, owner, ownerName, securityMode);
        this.presetVariables();
    }

    private void presetVariables() {
        this.storedFluid = BasicFluidTank.create(MekanismConfig.general.entangloporterFluidBuffer.get(), this);
        this.fluidTanks = Collections.singletonList(this.storedFluid);
        this.storedChemical = BasicChemicalTank.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.chemicalTanks = Collections.singletonList(this.storedChemical);
        this.storedItem = EntangloporterInventorySlot.create(this);
        this.inventorySlots = Collections.singletonList(this.storedItem);
        this.storedEnergy = BasicEnergyContainer.create(MekanismConfig.general.entangloporterEnergyBuffer.getAsLong(), this);
        this.energyContainers = Collections.singletonList(this.storedEnergy);
        this.storedHeat = BasicHeatCapacitor.create(1.0, 1.0, 1000.0, null, this);
        this.heatCapacitors = Collections.singletonList(this.storedHeat);
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @NotNull
    public List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.chemicalTanks;
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatCapacitors;
    }

    @Override
    public void onContentsChanged() {
        this.dirty = true;
    }

    @Override
    public boolean update(BlockEntity tile) {
        boolean changedData = super.update(tile);
        if (tile instanceof TileEntityQuantumEntangloporter) {
            TileEntityQuantumEntangloporter entangloporter = (TileEntityQuantumEntangloporter)tile;
            this.activeQEs.put((Object)tile.getLevel().dimension(), (Object)entangloporter.getBlockPos(), (Object)entangloporter);
        } else {
            this.activeQEs.remove((Object)tile.getLevel().dimension(), (Object)tile.getBlockPos());
        }
        return changedData;
    }

    @Override
    public boolean onDeactivate(BlockEntity tile) {
        boolean changedData = super.onDeactivate(tile);
        this.activeQEs.remove((Object)tile.getLevel().dimension(), (Object)tile.getBlockPos());
        return changedData;
    }

    public void handleEject(long gameTime) {
        if (this.isValid() && !this.activeQEs.isEmpty() && this.lastEject != gameTime) {
            this.lastEject = gameTime;
            EnumMap typesToEject = new EnumMap(TransmissionType.class);
            ArrayList<Runnable> transferHandlers = new ArrayList<Runnable>(EnumUtils.TRANSMISSION_TYPES.length - 2);
            int expected = 6 * this.activeQEs.size();
            this.addEnergyTransferHandler(typesToEject, transferHandlers, expected);
            this.addFluidTransferHandler(typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(typesToEject, transferHandlers, expected);
            if (!typesToEject.isEmpty()) {
                for (TileEntityQuantumEntangloporter qe : this.activeQEs.values()) {
                    ServerLevel level;
                    if (!qe.canFunction() || (level = (ServerLevel)qe.getLevel()) == null || !level.shouldTickBlocksAt(ChunkPos.asLong((BlockPos)qe.getBlockPos()))) continue;
                    Direction facing = qe.getDirection();
                    for (Map.Entry entry : typesToEject.entrySet()) {
                        TransmissionType transmissionType = (TransmissionType)entry.getKey();
                        ConfigInfo config = qe.getConfig().getConfig(transmissionType);
                        if (config == null || !qe.getEjector().isEjecting(config, transmissionType)) continue;
                        for (Map.Entry<RelativeSide, DataType> sideEntry : config.getSideConfig()) {
                            if (!sideEntry.getValue().canOutput()) continue;
                            Direction side = sideEntry.getKey().getDirection(facing);
                            InventoryFrequency.accept((Consumer)entry.getValue(), qe, side, transmissionType);
                        }
                    }
                }
                for (Runnable transferHandler : transferHandlers) {
                    transferHandler.run();
                }
            }
        }
    }

    private static <TYPE> void accept(Consumer<TYPE> consumer, TileEntityQuantumEntangloporter qe, Direction side, TransmissionType transmissionType) {
        Object cachedCapability = qe.getCachedCapability(side, transmissionType);
        if (cachedCapability != null) {
            consumer.accept(cachedCapability);
        }
    }

    private void addEnergyTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        long toSend = this.storedEnergy.extract(this.storedEnergy.getMaxEnergy(), Action.SIMULATE, AutomationType.INTERNAL);
        if (toSend > 0L) {
            SendingEnergyAcceptorTarget target = new SendingEnergyAcceptorTarget(expected, this.storedEnergy, toSend);
            typesToEject.put(TransmissionType.ENERGY, target);
            transferHandlers.add(target);
        }
    }

    private void addFluidTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        FluidStack fluidToSend = this.storedFluid.extract(this.storedFluid.getCapacity(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!fluidToSend.isEmpty()) {
            SendingFluidHandlerTarget target = new SendingFluidHandlerTarget(fluidToSend, expected, this.storedFluid);
            typesToEject.put(TransmissionType.FLUID, target);
            transferHandlers.add(target);
        }
    }

    private void addChemicalTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        ChemicalStack toSend = this.storedChemical.extract(this.storedChemical.getCapacity(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!toSend.isEmpty()) {
            SendingChemicalHandlerTarget target = new SendingChemicalHandlerTarget(toSend, expected, this.storedChemical);
            typesToEject.put(TransmissionType.CHEMICAL, target);
            transferHandlers.add(target);
        }
    }

    private static class SendingEnergyAcceptorTarget
    extends EnergyAcceptorTarget
    implements Runnable,
    Consumer<IStrictEnergyHandler> {
        private final IEnergyContainer storedEnergy;
        private final long toSend;

        public SendingEnergyAcceptorTarget(int expectedSize, IEnergyContainer storedEnergy, long toSend) {
            super(expectedSize);
            this.storedEnergy = storedEnergy;
            this.toSend = toSend;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedEnergy.extract(EmitUtils.sendToAcceptors(this, this.toSend, EnergyNetwork.ENERGY), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IStrictEnergyHandler handler) {
            this.addHandler(handler);
        }
    }

    private static class SendingFluidHandlerTarget
    extends FluidHandlerTarget
    implements Runnable,
    Consumer<IFluidHandler> {
        private final FluidStack toSend;
        private final IExtendedFluidTank storedFluid;

        public SendingFluidHandlerTarget(@NotNull FluidStack toSend, int expectedSize, IExtendedFluidTank storedFluid) {
            super(expectedSize);
            this.toSend = toSend;
            this.storedFluid = storedFluid;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedFluid.extract(EmitUtils.sendToAcceptors(this, this.toSend.getAmount(), this.toSend), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IFluidHandler handler) {
            if (FluidUtils.canFill(handler, this.toSend)) {
                this.addHandler(handler);
            }
        }
    }

    private static class SendingChemicalHandlerTarget
    extends ChemicalHandlerTarget
    implements Runnable,
    Consumer<IChemicalHandler> {
        private final ChemicalStack toSend;
        private final IChemicalTank storedChemical;

        public SendingChemicalHandlerTarget(ChemicalStack toSend, int expectedSize, IChemicalTank storedChemical) {
            super(expectedSize);
            this.toSend = toSend;
            this.storedChemical = storedChemical;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedChemical.extract(EmitUtils.sendToAcceptors(this, this.toSend.getAmount(), this.toSend), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IChemicalHandler handler) {
            if (ChemicalUtil.canInsert(handler, this.toSend)) {
                this.addHandler(handler);
            }
        }
    }
}

