/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderDigitalMiner
extends MekanismTileEntityRenderer<TileEntityDigitalMiner> {
    private static final MekanismRenderer.LazyModel model = new MekanismRenderer.LazyModel(() -> new MekanismRenderer.Model3D().setTexture(MekanismRenderer.whiteIcon).bounds(0.0f, 1.0f));
    private static final int[] colors = new int[EnumUtils.DIRECTIONS.length];

    public static void resetCachedVisuals() {
        model.reset();
    }

    public RenderDigitalMiner(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityDigitalMiner miner, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        matrix.pushPose();
        matrix.translate((double)(-miner.getRadius()) + 0.01, (double)(miner.getMinY() - miner.getBlockPos().getY()) + 0.01, (double)(-miner.getRadius()) + 0.01);
        float diameter = (float)miner.getDiameter() - 0.02f;
        matrix.scale(diameter, (float)(miner.getMaxY() - miner.getMinY()) - 0.02f, diameter);
        RenderResizableCuboid.FaceDisplay faceDisplay = this.isInsideBounds(miner.getBlockPos().getX() - miner.getRadius(), miner.getMinY(), miner.getBlockPos().getZ() - miner.getRadius(), miner.getBlockPos().getX() + miner.getRadius() + 1, miner.getMaxY(), miner.getBlockPos().getZ() + miner.getRadius() + 1) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.BOTH;
        MekanismRenderer.renderObject(model.get(), matrix, renderer.getBuffer(Sheets.translucentCullBlockSheet()), colors, 0xF000F0, overlayLight, faceDisplay, this.getCamera());
        matrix.popPose();
    }

    @Override
    protected String getProfilerSection() {
        return "digitalMiner";
    }

    public boolean shouldRenderOffScreen(TileEntityDigitalMiner tile) {
        return true;
    }

    public boolean shouldRender(TileEntityDigitalMiner tile, Vec3 camera) {
        return tile.isClientRendering() && tile.canDisplayVisuals() && super.shouldRender((BlockEntity)tile, camera);
    }

    public AABB getRenderBoundingBox(TileEntityDigitalMiner tile) {
        if (tile.isClientRendering() && tile.canDisplayVisuals()) {
            BlockPos pos = tile.getBlockPos();
            int radius = tile.getRadius();
            return new AABB((double)(pos.getX() - radius), (double)tile.getMinY(), (double)(pos.getZ() - radius), (double)(pos.getX() + radius + 1), (double)(tile.getMaxY() + 1), (double)(pos.getZ() + radius + 1));
        }
        return super.getRenderBoundingBox((BlockEntity)tile);
    }

    static {
        int n = MekanismRenderer.getColorARGB(0xFFFFFF, 0.82f);
        RenderDigitalMiner.colors[Direction.DOWN.ordinal()] = n;
        RenderDigitalMiner.colors[Direction.UP.ordinal()] = n;
        int n2 = MekanismRenderer.getColorARGB(0xFFFFFF, 0.8f);
        RenderDigitalMiner.colors[Direction.NORTH.ordinal()] = n2;
        RenderDigitalMiner.colors[Direction.SOUTH.ordinal()] = n2;
        int n3 = MekanismRenderer.getColorARGB(0xFFFFFF, 0.78f);
        RenderDigitalMiner.colors[Direction.WEST.ordinal()] = n3;
        RenderDigitalMiner.colors[Direction.EAST.ordinal()] = n3;
    }
}

